set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2423',
      '41002304',
      82,
      NULL,
      '3223232',
      15,
      1,
      3,
      0,
      '230301',
      3,
      ' 4- 1-1984',
      13,
      55,
      0.070031,
      NULL,
      NULL,
      NULL,
      1.888217,
      NULL,
      0.105386,
      2.923870,
      3.807428,
      NULL,
      1,
      0,
      1.338512,
      1,
      0.309162,
      0.093937,
      0.483456,
      0,
      4.818025,
      1.320003,
      1.922995,
      2.801560,
      1,
      1.580301,
      6,
      NULL,
      0,
      NULL,
      0,
      1.838886,
      NULL,
      NULL,
      1.957827,
      NULL,
      NULL,
      3.461314,
      3.641469,
      0.096688,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.123738,
      1.180029,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333790,
      1.050908,
      1.912896,
      0.726870,
      1,
      0,
      NULL,
      NULL,
      1,
      1.168731,
      0.308439,
      0,
      0.793819,
      1.488081,
      1,
      1.918842,
      0,
      0.498478,
      1.417971,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      0.853720,
      1,
      5,
      1.304387,
      NULL,
      5.819199,
      3.928133,
      0.429535,
      1,
      0.773687,
      0,
      3,
      2.701012,
      6,
      3,
      NULL,
      5,
      0,
      2.756096,
      NULL,
      3.256931,
      6.823147,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      2.687315,
      1,
      0.605902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.304493,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2.358973,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.457769,
      NULL,
      2,
      1.200606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508741,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.735973,
      2,
      0,
      NULL,
      3.327348,
      NULL,
      1.212255,
      1.031323,
      NULL,
      1.384630,
      0.719734,
      0.409887,
      NULL,
      0,
      0,
      1.381890,
      0,
      0,
      1,
      1.205014,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      '32023',
      '',
      '',
      0.198393,
      '',
      '',
      '',
      0.313804,
      '',
      '',
      '',
      3.959210,
      1,
      2,
      NULL,
      1,
      2.877212,
      1,
      3,
      0);
commit;
end;
/


