set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9795808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0141',
      '24423001',
      51.035044,
      45,
      NULL,
      42.603490,
      5,
      1.143625,
      NULL,
      '434224',
      1,
      '11-19-2003',
      NULL,
      28,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0.616944,
      1,
      1.929574,
      0,
      1.407262,
      1,
      1.593789,
      0.841878,
      NULL,
      1.138080,
      7.509066,
      NULL,
      1.109354,
      5.551968,
      0.807680,
      NULL,
      NULL,
      1,
      0,
      1.853819,
      0.641660,
      0,
      NULL,
      NULL,
      1.179667,
      NULL,
      NULL,
      2.927167,
      0.290755,
      NULL,
      NULL,
      1,
      0.184457,
      NULL,
      2.562578,
      0.353115,
      3.831676,
      3.573427,
      2,
      1.776715,
      1,
      1.292137,
      0,
      NULL,
      0.930506,
      1,
      1,
      1.442948,
      1.906254,
      4.071863,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      0.012833,
      NULL,
      NULL,
      0.218264,
      1,
      5,
      2,
      NULL,
      1,
      NULL,
      0.517982,
      1.603354,
      1,
      NULL,
      1.647710,
      0,
      1.979639,
      0,
      0,
      0.771539,
      NULL,
      0,
      NULL,
      0.411622,
      NULL,
      1.509993,
      0.200156,
      0.321846,
      0,
      5,
      0.729866,
      7,
      NULL,
      4.252550,
      0.566281,
      0.420298,
      4.058129,
      0,
      1,
      2,
      6,
      7,
      NULL,
      0.882231,
      2,
      1.428593,
      3,
      0,
      6,
      5,
      2.112340,
      NULL,
      1.538706,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.701268,
      0.965835,
      1,
      1,
      NULL,
      0.316168,
      3.477165,
      1.795594,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.393777,
      2.396027,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.580866,
      NULL,
      1.177128,
      NULL,
      NULL,
      NULL,
      4,
      1,
      0.987714,
      1.637476,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.662641,
      5.496946,
      0.285572,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.892865,
      3,
      NULL,
      NULL,
      1.618397,
      1.646748,
      0,
      NULL,
      NULL,
      0,
      0.222188,
      0,
      0.203540,
      0,
      1,
      NULL,
      0.471590,
      NULL,
      1.891311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.082263,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '42120',
      '',
      '',
      1.749065,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      2.238645,
      1.914399,
      3.341217,
      2.451305,
      0,
      2.859489,
      NULL,
      3,
      1.264545);
commit;
end;
/


