set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9729939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-7-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '304',
      '03003203',
      NULL,
      NULL,
      '4022022',
      10,
      5,
      0,
      1,
      '344322',
      NULL,
      ' 3-14-1977',
      20,
      18,
      1.546369,
      NULL,
      NULL,
      1.415309,
      1.614792,
      1.970910,
      1,
      0,
      2,
      0.893164,
      NULL,
      1,
      2,
      0,
      0.413002,
      0.463751,
      0,
      0,
      NULL,
      NULL,
      5,
      1,
      0,
      0.172296,
      0.369807,
      1,
      3.816225,
      0.382070,
      NULL,
      0.792753,
      NULL,
      NULL,
      0.321131,
      NULL,
      NULL,
      0.397944,
      0,
      1,
      2,
      1.038151,
      0.885302,
      0.628214,
      0,
      0,
      NULL,
      0.020487,
      1,
      NULL,
      0,
      2,
      0,
      0,
      3,
      NULL,
      0.711408,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      1.787751,
      NULL,
      NULL,
      1.568119,
      NULL,
      NULL,
      1.208141,
      0.006622,
      0,
      0,
      3,
      1,
      0.837568,
      0.422025,
      NULL,
      0,
      0,
      0,
      0,
      1.372785,
      0.232874,
      NULL,
      0,
      0,
      1.976262,
      NULL,
      0.898103,
      NULL,
      0,
      1.660848,
      0.867379,
      0.709035,
      0.277278,
      1.214751,
      0,
      0.162844,
      4.274769,
      6.968029,
      0,
      0,
      3.197464,
      1,
      0,
      2.765700,
      0.780701,
      5,
      8,
      2,
      1.091228,
      NULL,
      4,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.860924,
      0.101596,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.175227,
      NULL,
      4,
      1,
      0.219191,
      NULL,
      1.100538,
      NULL,
      NULL,
      NULL,
      1,
      7.574413,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.938774,
      NULL,
      0,
      3,
      NULL,
      0,
      1,
      1.635249,
      NULL,
      0.859655,
      0.279350,
      1.348865,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471347,
      1.517128,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.054166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      NULL,
      0.832799,
      1,
      1.462140,
      NULL,
      3.591183,
      NULL,
      '14240',
      '',
      1,
      '',
      NULL,
      '',
      1,
      '',
      '',
      '',
      NULL,
      3,
      6,
      3,
      0.520227,
      NULL,
      2.609133,
      1,
      3);
commit;
end;
/


