set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9729939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '441',
      '30002221',
      7,
      46,
      '3103044',
      NULL,
      5,
      2.333932,
      1,
      '013300',
      3,
      NULL,
      51.929382,
      68,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.435752,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0.258535,
      2,
      0,
      NULL,
      0,
      1,
      NULL,
      3.599553,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.585837,
      1.143710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501336,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.561334,
      NULL,
      NULL,
      0.682136,
      NULL,
      0.588912,
      0,
      NULL,
      0.449025,
      1.257114,
      0,
      1,
      0,
      0.392982,
      NULL,
      NULL,
      0.914730,
      1,
      NULL,
      NULL,
      0.247621,
      0.307707,
      1,
      0,
      1,
      NULL,
      1,
      0.186754,
      NULL,
      1,
      0.991388,
      1,
      1,
      NULL,
      0,
      0.302586,
      1.666765,
      NULL,
      0,
      1,
      3,
      NULL,
      1.646896,
      0,
      1.578103,
      2.415413,
      1.194512,
      1.677857,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770274,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700328,
      1.309835,
      NULL,
      1,
      NULL,
      1.076521,
      0,
      1.430928,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.954101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.751945,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.511997,
      0.256669,
      3.367723,
      1.407980,
      0,
      NULL,
      1.274825,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.579540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0.313395,
      1,
      NULL,
      1.713579,
      NULL,
      1.720003,
      NULL,
      1,
      0.615884,
      1.746338,
      NULL,
      NULL,
      NULL,
      NULL,
      1.893819,
      0,
      0.326730,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.422281,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.447402,
      1.854918,
      NULL,
      NULL,
      NULL,
      1.275006,
      0.644783,
      1,
      3,
      NULL,
      '31332',
      '',
      1.393925,
      '',
      '',
      NULL,
      1,
      '',
      NULL,
      '',
      0,
      0,
      1.985508,
      2.518884,
      2.992125,
      1,
      0.839817,
      3,
      NULL);
commit;
end;
/


