set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9729939';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2231',
      '10121323',
      6.340445,
      NULL,
      '3041041',
      32.425832,
      NULL,
      0.118351,
      3,
      '303134',
      2.821995,
      ' 3-17-1978',
      17,
      47.336159,
      1.697807,
      NULL,
      3.642871,
      0.536313,
      1.665047,
      NULL,
      0.194437,
      0.317492,
      2,
      1,
      0.635819,
      1,
      5,
      0.808659,
      NULL,
      0.816920,
      1,
      1.820112,
      3.222219,
      0.332363,
      NULL,
      0,
      1.473254,
      0,
      NULL,
      1,
      2,
      1.942600,
      0.234441,
      0,
      NULL,
      NULL,
      1.035992,
      NULL,
      NULL,
      3.851611,
      1.660440,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.854860,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.310203,
      5,
      1,
      3,
      1,
      0,
      1.545760,
      0.762479,
      0.698090,
      1.084513,
      0.546796,
      NULL,
      0.947038,
      1.861340,
      0.675922,
      1.920022,
      0,
      1.454984,
      NULL,
      1,
      2.092140,
      0,
      1.871654,
      4.658683,
      NULL,
      6.814081,
      0.348501,
      1,
      8.679003,
      3,
      2.592354,
      3.142314,
      NULL,
      6.092428,
      NULL,
      3,
      NULL,
      3.307652,
      6,
      NULL,
      5.486459,
      NULL,
      0,
      4.824063,
      2.428569,
      0.357019,
      1,
      0.282213,
      NULL,
      NULL,
      9,
      1.997526,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      1.525880,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.000884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.383933,
      4,
      5,
      0.352590,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.664750,
      2.325092,
      1.329398,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.165336,
      1,
      NULL,
      1.106233,
      1,
      0.460478,
      0,
      0.771666,
      1.534814,
      1.674556,
      1.500848,
      1.218019,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.568854,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.846740,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006318,
      NULL,
      NULL,
      NULL,
      1.239022,
      1.743962,
      NULL,
      3.560140,
      NULL,
      NULL,
      '',
      0,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      0.491115,
      3,
      3,
      2,
      2.691042,
      NULL,
      3.938152,
      0.989684);
commit;
end;
/


