set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-2-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      NULL,
      NULL,
      '1103401',
      0,
      3,
      2.698710,
      NULL,
      '141430',
      3,
      ' 2- 2-1998',
      3,
      NULL,
      0.666417,
      NULL,
      0.965688,
      3,
      0,
      0,
      0.981127,
      0.694816,
      1,
      0.808876,
      NULL,
      0,
      1,
      0.117844,
      NULL,
      0.408819,
      5,
      2.426912,
      7.095186,
      1.509616,
      3.222605,
      2.034498,
      1.966207,
      0,
      3.258973,
      NULL,
      1,
      1.525325,
      3,
      0.897538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.610696,
      0.720189,
      0.902781,
      2.516111,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      0.796052,
      0,
      1.199957,
      1,
      2.818233,
      2,
      0.790704,
      NULL,
      1.289944,
      1,
      1,
      NULL,
      0,
      2,
      1.882850,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.204614,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.049480,
      1.218668,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.244714,
      0.279057,
      0,
      0,
      NULL,
      NULL,
      0,
      1.001593,
      2,
      1.483965,
      1.073515,
      NULL,
      1.399885,
      1.757619,
      0,
      0,
      1,
      0.104635,
      0.727123,
      1.685818,
      0,
      NULL,
      1,
      NULL,
      3.968358,
      3,
      NULL,
      0,
      4.992991,
      5,
      2.555861,
      2.736714,
      7,
      NULL,
      1,
      NULL,
      NULL,
      1.220933,
      NULL,
      NULL,
      NULL,
      1,
      2.416694,
      1,
      NULL,
      0,
      1,
      2,
      2.420900,
      3.982760,
      1.438676,
      0,
      NULL,
      2,
      1.433494,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.276771,
      1.662156,
      2,
      3,
      3,
      1,
      NULL,
      1.098719,
      0.081488,
      0,
      0.139590,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244474,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.649294,
      NULL,
      1.725115,
      0,
      2.149230,
      0.230252,
      NULL,
      1.556979,
      1,
      0,
      1,
      0,
      0.565600,
      1.195589,
      0.371414,
      0.935454,
      NULL,
      0,
      0.865297,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.867497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '41444',
      '',
      '',
      1.309631,
      '',
      '',
      '',
      0.984030,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


