set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      NULL,
      NULL,
      '2314320',
      17,
      1,
      0.705720,
      3,
      '132212',
      NULL,
      '10-26-1988',
      43,
      NULL,
      0.811885,
      NULL,
      NULL,
      3.238287,
      0.297170,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2.589914,
      1.318190,
      3,
      0,
      1.671717,
      4,
      1.710376,
      NULL,
      NULL,
      0.400961,
      2.163109,
      4.949341,
      NULL,
      0,
      2,
      0,
      1,
      0.757857,
      1.506641,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.153549,
      NULL,
      2,
      1.309071,
      NULL,
      2.396173,
      0.538672,
      2.319769,
      1,
      1.270869,
      NULL,
      0.251006,
      1.123104,
      NULL,
      3,
      NULL,
      NULL,
      0,
      1.277538,
      0,
      0,
      NULL,
      0,
      1,
      0.128981,
      NULL,
      NULL,
      NULL,
      1.655404,
      NULL,
      NULL,
      1,
      0,
      2.662087,
      0,
      2,
      1.873091,
      1.528709,
      0.372212,
      0,
      1,
      3,
      1.732578,
      1.106440,
      1,
      0.343123,
      1,
      1,
      1.082275,
      1.379978,
      NULL,
      NULL,
      NULL,
      0.435349,
      1,
      1.689770,
      1.993008,
      NULL,
      NULL,
      1,
      1.762119,
      0.094130,
      1.663271,
      1.138805,
      1,
      2.981310,
      1,
      1.642381,
      3.469251,
      2,
      2,
      2.581853,
      0,
      5,
      4,
      3,
      3.313338,
      NULL,
      NULL,
      0.742507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.136582,
      1,
      3.189142,
      3,
      3.930940,
      2,
      0,
      0,
      4,
      2,
      0.207508,
      2.121481,
      1.104596,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.822264,
      NULL,
      0,
      2.655927,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.735160,
      NULL,
      NULL,
      NULL,
      1.694431,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0.506028,
      NULL,
      NULL,
      0.364915,
      1,
      1.910957,
      1.092995,
      NULL,
      1,
      0.950462,
      0.991374,
      1,
      NULL,
      0.994301,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.626323,
      '40212',
      '',
      '',
      1,
      '',
      '',
      '',
      0.401170,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


