set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-1-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      NULL,
      NULL,
      '2424343',
      123.826964,
      4,
      1,
      1,
      '403312',
      1.686240,
      '11-16-1987',
      20,
      NULL,
      0.370955,
      NULL,
      1.274204,
      NULL,
      NULL,
      1.846902,
      NULL,
      0.138157,
      1.709349,
      1.803085,
      1.189116,
      1.965296,
      5.576688,
      1,
      1.153690,
      NULL,
      NULL,
      0,
      1,
      0,
      5,
      2.908366,
      1.346990,
      1.371487,
      3.162557,
      0,
      1.883739,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.777417,
      1.184422,
      1.339746,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.655895,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834271,
      0,
      0.792419,
      NULL,
      3.802935,
      0,
      1.168719,
      1,
      1.970248,
      0,
      0.783757,
      0,
      0.361350,
      1.844500,
      0.174783,
      0.209827,
      0,
      NULL,
      0,
      NULL,
      1.148400,
      1,
      1,
      1,
      1,
      0.198252,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0.996996,
      NULL,
      NULL,
      1.096616,
      0.305580,
      NULL,
      0,
      4,
      3.679124,
      NULL,
      2.328781,
      4,
      1,
      0,
      NULL,
      NULL,
      0.191061,
      1.942361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.827361,
      NULL,
      0,
      1,
      1.362054,
      0,
      1.277261,
      1.100627,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.292746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.883107,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962376,
      0,
      1,
      0,
      0.921090,
      NULL,
      NULL,
      NULL,
      0.433554,
      NULL,
      0.874668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.537049,
      0.903845,
      2,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.117306,
      2,
      1,
      0,
      0.142697,
      1,
      1.886580,
      0.369626,
      0,
      1,
      0,
      0.735783,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '13303',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


