set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01210204',
      NULL,
      49.783743,
      NULL,
      185,
      1,
      3.856467,
      3,
      '143441',
      NULL,
      ' 5- 4-2000',
      13,
      42,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.990796,
      3.017287,
      2.306094,
      NULL,
      1.940163,
      0.076919,
      0,
      0,
      NULL,
      1.349797,
      1,
      NULL,
      NULL,
      1.695099,
      1.255534,
      0,
      0,
      4,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1.969601,
      0.568205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.177119,
      0,
      0.330019,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      5,
      1,
      0,
      1,
      4.591914,
      4,
      NULL,
      0,
      4.702323,
      NULL,
      0,
      0.394552,
      NULL,
      0.886748,
      NULL,
      1,
      1.527606,
      NULL,
      1,
      0.813310,
      NULL,
      NULL,
      1.240418,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.831905,
      1.301917,
      0.230007,
      1,
      5.734651,
      4.393096,
      4.468567,
      3,
      2.192108,
      4.311941,
      1.538005,
      5,
      0,
      0.349831,
      5.203259,
      2.744283,
      0,
      1.945040,
      NULL,
      0.976380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.504452,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.788339,
      NULL,
      NULL,
      NULL,
      NULL,
      1.894451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2.274419,
      NULL,
      0.322244,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.778294,
      0.479799,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.855311,
      0.971446,
      0,
      0,
      3,
      2,
      NULL,
      1.709591,
      0,
      1.692390,
      1,
      0,
      0.609491,
      0.896397,
      0.246063,
      0.661938,
      0,
      NULL,
      1.108966,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.928822,
      '13021',
      '',
      '',
      0.258073,
      '',
      '',
      '',
      1.562926,
      '',
      '',
      '',
      1.209168,
      5,
      1,
      3,
      1,
      1.356732,
      NULL,
      NULL,
      2);
commit;
end;
/


