set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '010',
      '24131333',
      68,
      NULL,
      '0001114',
      49,
      4,
      2.917753,
      3,
      '030034',
      3.850086,
      NULL,
      38.292545,
      95.452760,
      1.012886,
      NULL,
      1,
      1,
      1.044359,
      1,
      0,
      0.331803,
      2,
      0,
      1.158821,
      1,
      3,
      1,
      4,
      NULL,
      1.204312,
      NULL,
      5,
      1.693440,
      0,
      0,
      1.038023,
      1.721914,
      2.447843,
      1,
      3,
      3,
      2.080831,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.287335,
      0.242262,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.338816,
      0,
      2,
      0,
      2,
      1.924413,
      1.006777,
      NULL,
      NULL,
      0.748735,
      NULL,
      NULL,
      1,
      1.971262,
      0.271282,
      1.221214,
      0.930057,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0.149567,
      NULL,
      1,
      1,
      0,
      1.876135,
      NULL,
      1.490446,
      1.717908,
      NULL,
      NULL,
      1,
      NULL,
      0.132673,
      0.910895,
      1,
      3,
      1.883554,
      0,
      0.105940,
      1,
      0.348754,
      1.451359,
      0,
      1,
      2,
      0.399931,
      1.739780,
      NULL,
      5,
      1.378609,
      0.979381,
      2.345630,
      NULL,
      7,
      1,
      5.804665,
      NULL,
      1.186041,
      NULL,
      NULL,
      NULL,
      0.304146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.785491,
      3.043970,
      0.491545,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368924,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.865343,
      1.336026,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      7,
      5,
      1.028166,
      1,
      1.130354,
      NULL,
      NULL,
      NULL,
      0,
      5.587703,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.571843,
      NULL,
      0.238684,
      3.013062,
      2,
      NULL,
      1.585017,
      2,
      1.863023,
      2.598383,
      NULL,
      0,
      1.672369,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '43140',
      '',
      '',
      0.245828,
      '',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      5.294500,
      2.013974,
      1.967541,
      2.737547,
      0,
      3,
      NULL,
      2.851823,
      0.250118);
commit;
end;
/


