set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1100',
      NULL,
      NULL,
      61,
      '2111012',
      42,
      2,
      3.878394,
      3,
      NULL,
      5.369020,
      NULL,
      NULL,
      20.001204,
      1,
      NULL,
      NULL,
      NULL,
      2.050881,
      0.178486,
      NULL,
      0,
      0,
      2,
      0,
      1.570276,
      4,
      1.653438,
      5.058679,
      4,
      1.475548,
      0,
      8.470675,
      0.569804,
      0,
      NULL,
      NULL,
      1.277147,
      2,
      0,
      2,
      3,
      0,
      1.161302,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      5.924105,
      3,
      0.494386,
      0,
      0,
      2.827760,
      0.230932,
      0.898951,
      NULL,
      NULL,
      0,
      2.238477,
      0.811050,
      0.664981,
      1.669230,
      1,
      0.629221,
      3,
      0.087978,
      0,
      1.138818,
      NULL,
      1,
      0,
      3.172590,
      0.995912,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.909607,
      7.298036,
      NULL,
      5.380107,
      6,
      3.707115,
      1.641107,
      1.380338,
      2.176147,
      2.438269,
      NULL,
      1,
      8.081671,
      1,
      1,
      0,
      1.923832,
      NULL,
      NULL,
      0.966673,
      0.355135,
      NULL,
      3,
      1.171560,
      6.116367,
      NULL,
      3.172936,
      NULL,
      NULL,
      NULL,
      NULL,
      5.090235,
      0.702396,
      4,
      NULL,
      2.578486,
      9.919218,
      7,
      1.346074,
      8,
      NULL,
      3.154350,
      7.989267,
      2,
      1.722061,
      NULL,
      5,
      1.791685,
      1.994201,
      0.241805,
      1,
      1.967752,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.820048,
      2,
      2,
      0.983548,
      0,
      1.101944,
      1.690021,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      3.627872,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.052351,
      4.765658,
      0,
      3,
      NULL,
      NULL,
      NULL,
      0,
      5.967691,
      1.590864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      3.925288,
      NULL,
      2.094779,
      1,
      1.092547,
      1.415067,
      2.519316,
      NULL,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0.677709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.061703,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      '',
      '',
      '',
      0.032734,
      0,
      0,
      0.865953,
      3.415534,
      5,
      3,
      0,
      3);
commit;
end;
/


