set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8936345';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-1-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0033',
      '04041010',
      NULL,
      3,
      '0314031',
      133.828757,
      3,
      2,
      NULL,
      '230202',
      2.312212,
      ' 2-18-1981',
      31,
      21.487198,
      1,
      NULL,
      1.674046,
      NULL,
      0,
      0.711925,
      0.534700,
      0.136522,
      0.278803,
      NULL,
      0.598774,
      NULL,
      6,
      NULL,
      3.905619,
      NULL,
      NULL,
      0,
      5.426426,
      0.919458,
      NULL,
      NULL,
      0.250115,
      0,
      4,
      0,
      4.552144,
      1,
      4.468335,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.588255,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.726739,
      0.664694,
      1,
      4,
      0,
      0,
      NULL,
      1.856720,
      NULL,
      NULL,
      0.257845,
      NULL,
      NULL,
      1,
      5.492336,
      3,
      0.959324,
      4,
      7,
      NULL,
      1,
      2,
      0,
      5.001676,
      1,
      1.590424,
      2,
      0.871509,
      0,
      0.840725,
      NULL,
      0,
      NULL,
      NULL,
      0.231471,
      3,
      1,
      0,
      5.900903,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.236590,
      1.957271,
      5,
      1,
      2.665188,
      NULL,
      6,
      NULL,
      8.680755,
      4,
      4,
      7,
      NULL,
      7,
      NULL,
      0.998712,
      1.999899,
      0,
      9.194723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4.865428,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.949095,
      NULL,
      8,
      0.590363,
      0.720984,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.225460,
      3.135149,
      0.755518,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5.854689,
      0.006569,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.991074,
      5.870501,
      0.775032,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.189504,
      3,
      3,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      1.058546,
      NULL,
      0,
      1,
      0.773472,
      1,
      0.728700,
      1.031285,
      1,
      1,
      0.702133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      '01042',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.635678,
      NULL,
      NULL,
      '',
      0.068912,
      NULL,
      1,
      0,
      NULL,
      2,
      2.675710,
      NULL,
      0);
commit;
end;
/


