set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '2',
      NULL,
      NULL,
      NULL,
      7,
      3,
      2.077996,
      1,
      '120101',
      NULL,
      NULL,
      27,
      NULL,
      1.529799,
      NULL,
      NULL,
      3.205385,
      NULL,
      NULL,
      1,
      1.639309,
      1.209018,
      0.812038,
      1,
      1.360789,
      0.650706,
      0.971227,
      1,
      2,
      NULL,
      0.779955,
      4,
      0.097070,
      0.405261,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.340150,
      0,
      3.093930,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      2.794614,
      1.970784,
      0,
      0.517553,
      1,
      0,
      0.082374,
      0,
      0.554414,
      2,
      3,
      2,
      1,
      NULL,
      0.070207,
      NULL,
      NULL,
      1.328335,
      NULL,
      NULL,
      1,
      1.242199,
      NULL,
      3.183149,
      1.145464,
      NULL,
      0.925242,
      1.953599,
      1,
      0,
      1,
      1.625109,
      1,
      0.508160,
      NULL,
      NULL,
      1,
      1.098901,
      1.639427,
      NULL,
      1.633496,
      1,
      0.272742,
      0,
      NULL,
      1,
      3.149218,
      1.268732,
      NULL,
      1.769109,
      0.629391,
      0.696879,
      1,
      1.134241,
      1.663912,
      1,
      0.046090,
      NULL,
      0,
      6,
      1,
      0.760969,
      NULL,
      8,
      0.274182,
      1.901877,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.009000,
      1.186927,
      1.163952,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.665865,
      NULL,
      NULL,
      NULL,
      NULL,
      0.888380,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.075320,
      1,
      1.173469,
      4.232352,
      1,
      0,
      1.473516,
      NULL,
      NULL,
      NULL,
      1.512819,
      1.290265,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.584821,
      2,
      1.343487,
      NULL,
      1.254885,
      1.852678,
      0.336521,
      0,
      0.707474,
      0.706392,
      1.000769,
      1,
      1.735952,
      1.964805,
      0,
      1.633042,
      0.056198,
      1.073348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.221473,
      '',
      NULL,
      '',
      0,
      NULL,
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


