set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      NULL,
      NULL,
      NULL,
      NULL,
      9.037710,
      1,
      NULL,
      1,
      '402244',
      0,
      ' 6- 8-2001',
      24,
      NULL,
      1.610233,
      NULL,
      14.524400,
      1,
      1,
      0.894109,
      2.725519,
      1,
      NULL,
      0.126535,
      1,
      0.828086,
      1,
      1,
      1,
      3.456171,
      1.125330,
      0,
      5,
      NULL,
      0.500597,
      0,
      1,
      0.765792,
      0,
      1,
      3,
      1.407192,
      1,
      1.408999,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4.719775,
      0.869742,
      NULL,
      3.992221,
      1,
      NULL,
      2,
      1.141113,
      NULL,
      3.513702,
      0,
      NULL,
      3,
      2.694858,
      1.305037,
      1.270925,
      0,
      0,
      0.574761,
      1,
      1.529564,
      2,
      NULL,
      1,
      1,
      0,
      1.956182,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.770116,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      1.300299,
      0,
      0,
      NULL,
      0,
      0.107197,
      1.366760,
      NULL,
      0,
      1.603015,
      0,
      0.837016,
      NULL,
      NULL,
      6.632226,
      2,
      0.012982,
      2,
      NULL,
      1,
      0.625364,
      NULL,
      1.885113,
      1.549435,
      0,
      1,
      1.634388,
      NULL,
      0.614697,
      0.131674,
      9.202878,
      NULL,
      NULL,
      1,
      1,
      NULL,
      6.116502,
      5,
      3,
      NULL,
      3,
      1.942426,
      NULL,
      NULL,
      1.373000,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.630331,
      1,
      1,
      1,
      0,
      1.808965,
      0.862400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.093092,
      NULL,
      NULL,
      1.959185,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.616726,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.635807,
      NULL,
      5.105141,
      2,
      0.286851,
      NULL,
      NULL,
      NULL,
      1.478099,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      3.510131,
      NULL,
      3.714325,
      0.965745,
      2,
      1.954425,
      2,
      0,
      0.518386,
      0.254198,
      1.542246,
      1.345461,
      1,
      1,
      1,
      1.645860,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.860687,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.521654,
      '33242',
      '31122',
      '',
      0.235388,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


