set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      '0003243',
      10.621805,
      5,
      3.540906,
      NULL,
      NULL,
      2.409596,
      ' 6-19-1988',
      40,
      NULL,
      1.818579,
      NULL,
      11,
      0,
      1.133222,
      0.244721,
      NULL,
      NULL,
      1.957816,
      1,
      NULL,
      1.517757,
      0.764734,
      0.576179,
      0.035823,
      NULL,
      1,
      1.922057,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.663219,
      1.606851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1.279787,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.654791,
      4,
      4,
      0,
      NULL,
      1.000190,
      1.214877,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.471884,
      2,
      3.794721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611032,
      1.550385,
      1.265712,
      NULL,
      0,
      NULL,
      1,
      1.112959,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.872301,
      1.428079,
      0,
      0.680104,
      1.289446,
      1,
      2,
      5,
      NULL,
      1,
      4,
      1.228130,
      3.146069,
      6.350195,
      1,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      2,
      0,
      NULL,
      NULL,
      6.383507,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      0.860672,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.297782,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295321,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.980347,
      NULL,
      NULL,
      0.191314,
      2.943393,
      1.421584,
      NULL,
      0,
      0.721877,
      0.173134,
      NULL,
      0,
      2,
      1.371481,
      NULL,
      NULL,
      NULL,
      0,
      1.353386,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.746833,
      NULL,
      0,
      NULL,
      2.484152,
      0.601391,
      1.657378,
      2,
      0,
      0,
      0,
      1.182449,
      0.885378,
      NULL,
      NULL,
      1,
      0.617072,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.315958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.060699,
      '',
      '',
      NULL,
      2,
      '24024',
      NULL,
      '',
      0.208649,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


