set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      NULL,
      NULL,
      '1210201',
      97,
      3,
      NULL,
      3,
      '430120',
      2,
      ' 2-24-1982',
      25.801482,
      NULL,
      NULL,
      NULL,
      6.595079,
      1,
      NULL,
      1.786107,
      0.530952,
      1,
      0,
      1,
      0,
      NULL,
      1.328477,
      1.917591,
      1.239523,
      2,
      NULL,
      1.070770,
      1.559631,
      1.125054,
      0.917310,
      0,
      0,
      0.865705,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.519013,
      1,
      0.845841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.837929,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088953,
      NULL,
      0.527846,
      0.825074,
      0.951631,
      1,
      0.231507,
      1.266273,
      1,
      0.845188,
      1,
      1,
      0.632044,
      NULL,
      1,
      NULL,
      1.193121,
      1,
      0.654029,
      NULL,
      0,
      1.968891,
      NULL,
      1,
      4.111064,
      0,
      1,
      1,
      0,
      8.681631,
      5,
      3.092114,
      0,
      6,
      8,
      1.620332,
      1.767996,
      2,
      8,
      1.921329,
      4,
      8.015524,
      4,
      6.837219,
      4.400176,
      6,
      3,
      3,
      0.878881,
      NULL,
      NULL,
      2.700251,
      1.502363,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.741838,
      NULL,
      0,
      0,
      1,
      0.630042,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.785665,
      NULL,
      1.380105,
      2.688004,
      NULL,
      4.896248,
      1,
      NULL,
      NULL,
      1.945087,
      0.679614,
      2,
      0.851204,
      1.822327,
      NULL,
      NULL,
      NULL,
      NULL,
      2.224985,
      4,
      3,
      5,
      2,
      5,
      0.125062,
      NULL,
      NULL,
      NULL,
      13.069034,
      2,
      3,
      NULL,
      5.280393,
      3,
      3.396972,
      1,
      2.137107,
      1,
      3.266046,
      0.900139,
      3.112634,
      2,
      2.325464,
      NULL,
      0.984906,
      3.823240,
      NULL,
      1.425418,
      0,
      1.356706,
      0,
      1.670730,
      NULL,
      1.930091,
      0,
      1.652644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '10240',
      '',
      NULL,
      3,
      '02032',
      '',
      '',
      1.814481,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


