set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '334',
      '23044333',
      31,
      60.955789,
      '4134344',
      NULL,
      2,
      NULL,
      1,
      '101240',
      NULL,
      ' 2- 7-1987',
      51,
      60,
      0,
      NULL,
      0,
      1.269930,
      NULL,
      1.440486,
      1,
      1,
      0,
      1.998724,
      NULL,
      1,
      1,
      1,
      0,
      0.575808,
      NULL,
      0,
      0,
      0.419646,
      0,
      0.049779,
      NULL,
      1.125142,
      0.876307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747168,
      0,
      NULL,
      1.047131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.285975,
      0,
      0.117993,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.749255,
      NULL,
      0,
      1.671198,
      0,
      0,
      0.818941,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.033948,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.420408,
      0.240930,
      1,
      0,
      NULL,
      1,
      NULL,
      3.265913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.548344,
      0,
      1.850505,
      5.012928,
      3,
      NULL,
      1.001664,
      NULL,
      NULL,
      1.563194,
      0,
      1,
      NULL,
      2.806340,
      1.819851,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.240444,
      1,
      1,
      NULL,
      1.158214,
      1,
      1.700589,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      3.099782,
      1.188195,
      1.949454,
      NULL,
      1,
      NULL,
      0,
      1.807125,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.907261,
      1.718119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.316170,
      1.848437,
      3,
      1,
      0,
      1.583186,
      NULL,
      0,
      2.171283,
      0,
      NULL,
      0,
      0.614358,
      1,
      1.242313,
      1.412347,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.101448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '',
      NULL,
      '',
      NULL,
      '30231',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      5.857999,
      6.423354,
      NULL,
      4.568386,
      NULL,
      1,
      2,
      3.240077,
      1);
commit;
end;
/


