set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8527538';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '210',
      '13123401',
      49.863339,
      9.948535,
      '1203223',
      29,
      3,
      2.183598,
      2,
      NULL,
      1.053651,
      ' 9-27-2001',
      NULL,
      52.644222,
      0.607486,
      NULL,
      1,
      1,
      3.594239,
      1,
      NULL,
      1,
      1.856645,
      1,
      0.185356,
      NULL,
      2.806141,
      NULL,
      0.577139,
      1.184371,
      0.627843,
      NULL,
      NULL,
      NULL,
      0.902084,
      0,
      4.824249,
      0,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      1.493723,
      NULL,
      NULL,
      3,
      1,
      0.072067,
      NULL,
      NULL,
      1.101958,
      1.946263,
      0,
      3.144206,
      1.850212,
      2.824324,
      3,
      2,
      NULL,
      NULL,
      0,
      1,
      1.512318,
      3,
      0,
      1.966404,
      1,
      1.844774,
      0,
      1,
      1.796668,
      1.666498,
      NULL,
      NULL,
      0.851360,
      NULL,
      NULL,
      1.646873,
      0,
      0,
      0.326563,
      NULL,
      1.914931,
      1.309154,
      0,
      0,
      0,
      1.297674,
      0.419741,
      NULL,
      1.309428,
      NULL,
      1,
      1,
      1.883197,
      1.254008,
      NULL,
      1,
      1.642586,
      0,
      1.407286,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319671,
      0,
      1.005438,
      1,
      2,
      7.931297,
      3.948206,
      NULL,
      2,
      2.762340,
      6,
      4,
      6.270520,
      1.391985,
      1,
      1.387597,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.801366,
      1.935254,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.433842,
      1,
      0.767352,
      3,
      2,
      NULL,
      5,
      NULL,
      0,
      0.959160,
      0,
      1.848551,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.152208,
      3,
      3.090804,
      1,
      0,
      1.823679,
      NULL,
      1.449706,
      0.867156,
      2.402350,
      2,
      1,
      1,
      1.518456,
      NULL,
      1,
      1.208846,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730406,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      '',
      '',
      1,
      '23231',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      2,
      3.332290,
      NULL,
      2.722359,
      1,
      2,
      2,
      3);
commit;
end;
/


