set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-3-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      NULL,
      '3343004',
      NULL,
      4,
      3,
      3,
      '243322',
      NULL,
      NULL,
      35.322902,
      NULL,
      0.011340,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.584878,
      1.602558,
      NULL,
      1,
      1,
      1,
      0,
      0.444863,
      0.130584,
      0,
      0,
      0.790676,
      1.802113,
      1.762715,
      NULL,
      NULL,
      NULL,
      1.170296,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.861509,
      0.331050,
      0,
      0,
      0.214799,
      1,
      1.683685,
      NULL,
      0.410509,
      2.820579,
      1.323778,
      0.689003,
      1,
      0.800275,
      0.772519,
      NULL,
      2,
      NULL,
      2.709530,
      1.823045,
      1,
      1.647055,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      1.717530,
      1,
      1,
      1.977114,
      0,
      NULL,
      0,
      0.204898,
      0.161324,
      0,
      1.282505,
      1.439591,
      1,
      1,
      1,
      0.622458,
      1,
      NULL,
      1,
      2.015973,
      0,
      7,
      0,
      1.628537,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.829515,
      1,
      1,
      1,
      4.699415,
      0,
      NULL,
      4,
      NULL,
      4.494030,
      0,
      5,
      NULL,
      NULL,
      NULL,
      5.887867,
      1.200964,
      1.932942,
      0.934755,
      0.183913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.702636,
      1,
      NULL,
      NULL,
      0.298058,
      1.203458,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769020,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      4,
      2.145509,
      3,
      NULL,
      0.752107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.161226,
      2.129008,
      0.632876,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.834329,
      0.127525,
      1.850400,
      2,
      1.047218,
      0,
      0,
      2,
      1,
      3,
      NULL,
      NULL,
      1.027114,
      1,
      1.888019,
      1.013597,
      1.629875,
      1.019390,
      1,
      0.208436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.852086,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.940125,
      NULL,
      0.533153,
      1.946133,
      1.353207,
      0.817699,
      1.249784,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '31021',
      '03013',
      '',
      0,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


