set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-3-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      31.208401,
      11,
      '3110323',
      11.201564,
      1,
      3.562825,
      2,
      '243323',
      0,
      ' 7-18-1976',
      15,
      119.467387,
      0.642519,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      NULL,
      1.315120,
      0.662944,
      0.655595,
      1.795291,
      1.246103,
      NULL,
      0.585974,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.894312,
      3.179551,
      NULL,
      0.110793,
      1.697851,
      0.155472,
      NULL,
      3.151017,
      2,
      0,
      0,
      1,
      0,
      1.586040,
      1.918749,
      1.743828,
      3.875553,
      3.622690,
      NULL,
      1.972724,
      NULL,
      2.734962,
      1,
      NULL,
      1,
      1.260862,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.879944,
      0.065192,
      0.730449,
      1.456395,
      1.338485,
      1.150582,
      1,
      1,
      1.556837,
      1.719163,
      1,
      0,
      1,
      0.033631,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.265581,
      1.744312,
      1,
      NULL,
      2.875297,
      1.509701,
      3.041899,
      3.043595,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.881646,
      5,
      NULL,
      1,
      1,
      0,
      7,
      4,
      NULL,
      3.460053,
      3.003586,
      1.502945,
      1,
      4,
      0,
      2,
      1.479528,
      1.104057,
      7.530679,
      0.058929,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.314133,
      NULL,
      1,
      NULL,
      0,
      0,
      1.686083,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247539,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      6.660849,
      0.964957,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.420290,
      2.085457,
      0.584882,
      0,
      0.911465,
      NULL,
      NULL,
      NULL,
      1.823148,
      1.026169,
      0.582097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.144077,
      1.946284,
      1.891664,
      3,
      0.506761,
      1,
      1,
      1.561241,
      1.608925,
      NULL,
      0,
      0.753262,
      0.064973,
      1.168651,
      0.327555,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.797394,
      NULL,
      1,
      1.046160,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.550582,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.851310,
      '14101',
      '33020',
      '',
      0.847434,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      5.446491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


