set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '132',
      NULL,
      10,
      22,
      '3111042',
      80.043657,
      NULL,
      1.512763,
      3,
      '010034',
      NULL,
      NULL,
      60,
      38.757332,
      0.913620,
      NULL,
      1.277661,
      0.709248,
      0.384837,
      NULL,
      0,
      1.035420,
      NULL,
      0,
      3,
      1,
      0.689550,
      NULL,
      0,
      1.711421,
      NULL,
      1,
      1,
      0.162003,
      1.078126,
      0.480044,
      0,
      1.152091,
      0.832154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.334559,
      0.850997,
      1.674383,
      1.401801,
      0,
      1.966502,
      2.907802,
      2,
      0.951959,
      2.035110,
      0.625177,
      NULL,
      0.559712,
      0.485038,
      1.201584,
      1.093118,
      NULL,
      1.486376,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.398283,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1.109568,
      1.065240,
      1.439402,
      1.198685,
      1.543702,
      NULL,
      0.238616,
      1.821565,
      0.644979,
      0,
      0.492347,
      NULL,
      1,
      0,
      NULL,
      0.450482,
      NULL,
      0.947746,
      NULL,
      2.986024,
      0,
      2.237440,
      0,
      NULL,
      1,
      3,
      4,
      3.849465,
      1.002308,
      5.616372,
      1.568055,
      0.131274,
      3.962300,
      7.094944,
      2,
      2,
      0.157694,
      4.680501,
      0.629083,
      NULL,
      0.668247,
      0.128419,
      1,
      NULL,
      NULL,
      NULL,
      3.332943,
      0.171943,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747917,
      0,
      1,
      1,
      1.145747,
      1,
      1.609155,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.673234,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      2,
      1.566924,
      NULL,
      0,
      0,
      0.425654,
      NULL,
      1.666786,
      1.053036,
      1,
      1.095436,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.316554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.060045,
      1,
      1,
      0,
      0.641544,
      0.234632,
      0,
      NULL,
      2.487190,
      NULL,
      NULL,
      1.571104,
      0.995871,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.719586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.130789,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.229734,
      '01021',
      NULL,
      '',
      1.741314,
      '',
      '',
      '',
      1.591175,
      '41413',
      '',
      '',
      3,
      3.026032,
      2,
      3.925559,
      0,
      NULL,
      1.460513,
      1,
      1.600665);
commit;
end;
/


