set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-10-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '133',
      '31430413',
      14.446754,
      59,
      '2441343',
      144,
      3,
      3,
      NULL,
      '343312',
      1,
      NULL,
      53,
      51,
      1,
      NULL,
      NULL,
      0.966993,
      1,
      1.071271,
      NULL,
      0,
      NULL,
      0.754883,
      1,
      1.095759,
      1.488567,
      0,
      1.834362,
      0.063632,
      NULL,
      0.556652,
      1.574113,
      NULL,
      0.973529,
      0.467623,
      1,
      1.108557,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.776857,
      NULL,
      0.088340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.379395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790567,
      1.095491,
      0.802495,
      1,
      0.342862,
      1.287995,
      NULL,
      1.526723,
      0.712110,
      1,
      NULL,
      0.075596,
      NULL,
      NULL,
      1.944010,
      1,
      0,
      0,
      1.552323,
      NULL,
      0,
      2.156149,
      NULL,
      1,
      0,
      1.749495,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1.900402,
      1.975864,
      0,
      0,
      0,
      5.627108,
      NULL,
      3,
      6,
      9.268714,
      5,
      3,
      NULL,
      1.101692,
      0.551412,
      1.387386,
      0,
      NULL,
      NULL,
      5.512494,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.828203,
      1,
      1,
      0,
      0,
      1.188369,
      1,
      1.719798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.288335,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.398597,
      NULL,
      1,
      5.916080,
      5.994218,
      NULL,
      1.494901,
      1,
      0,
      0.726749,
      NULL,
      NULL,
      NULL,
      0.539644,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.153287,
      1.859819,
      1,
      3.429120,
      0.736225,
      0.508607,
      0,
      0,
      0.438687,
      0.478245,
      0,
      0.633253,
      0,
      0.350108,
      NULL,
      1,
      1.660819,
      0.003414,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      '40214',
      '23214',
      NULL,
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      '',
      '',
      0.455569,
      0.351081,
      0.608418,
      NULL,
      0.816720,
      NULL,
      2,
      1.644772,
      3);
commit;
end;
/


