set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-9-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1012',
      '31120124',
      60.981073,
      58,
      '0143032',
      44.100248,
      1,
      0,
      0,
      NULL,
      6,
      ' 2-21-1980',
      24,
      21,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      1.075534,
      0.843282,
      1,
      0,
      1,
      5,
      NULL,
      0.099734,
      1.686758,
      NULL,
      1,
      0,
      NULL,
      0.782570,
      0,
      1,
      NULL,
      1,
      NULL,
      0.494485,
      1.839555,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4.510833,
      1,
      1.661836,
      3,
      0.826431,
      NULL,
      3.922777,
      NULL,
      NULL,
      2.165567,
      0.730831,
      0.125703,
      0.491457,
      NULL,
      1.827466,
      1,
      1,
      1,
      2,
      0.068106,
      NULL,
      1.802782,
      0.665468,
      0,
      1,
      1.993403,
      0,
      NULL,
      NULL,
      0.018376,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      1.412000,
      NULL,
      1.118379,
      0.881682,
      0,
      0,
      NULL,
      1.432322,
      0,
      0,
      0.759435,
      1,
      NULL,
      NULL,
      1.343115,
      2.946082,
      0,
      0,
      1,
      1.355451,
      2.186089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.385626,
      0.601206,
      1,
      0,
      0,
      3.890955,
      5.312585,
      2,
      5.898737,
      3.024371,
      5,
      2.270521,
      5.720346,
      NULL,
      NULL,
      1.602188,
      NULL,
      NULL,
      NULL,
      8,
      0.176750,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.146009,
      1.311430,
      0,
      1,
      0.453083,
      1.830279,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.903002,
      NULL,
      NULL,
      NULL,
      NULL,
      1.083341,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.121047,
      0.028275,
      1,
      NULL,
      NULL,
      NULL,
      0.710613,
      1.717243,
      1.231710,
      6.905643,
      NULL,
      1,
      1.846459,
      NULL,
      NULL,
      NULL,
      1.767791,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      3,
      1.697394,
      NULL,
      1,
      0,
      2,
      0.363701,
      1,
      0.247994,
      0.687127,
      NULL,
      1,
      0,
      1.932834,
      0.045412,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.161095,
      '22303',
      '41003',
      '',
      0,
      '',
      '',
      '',
      2.497732,
      '43334',
      '',
      '',
      NULL,
      1,
      NULL,
      NULL,
      2,
      2,
      0,
      NULL,
      3.033481);
commit;
end;
/


