set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-3-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34310231',
      13.957583,
      NULL,
      '0110301',
      190,
      0,
      1,
      0,
      '212330',
      2,
      ' 6-20-1996',
      35.654983,
      NULL,
      1,
      NULL,
      0.165209,
      1,
      3,
      1,
      1.540419,
      0.914963,
      NULL,
      3,
      0,
      1.238950,
      2.401541,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.120087,
      1,
      1,
      0.572043,
      0.121867,
      NULL,
      NULL,
      1.962690,
      0,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      0.774385,
      0,
      1.706850,
      1,
      NULL,
      0.128281,
      0,
      0,
      0,
      0,
      0,
      0.034323,
      2.502204,
      1.544305,
      3.520686,
      1.811598,
      1.813618,
      1,
      1.061197,
      NULL,
      1.508319,
      NULL,
      NULL,
      1,
      3.657568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.928721,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      0.236233,
      1.298639,
      1.981999,
      1,
      0.077698,
      0,
      0,
      1.183966,
      1,
      0,
      NULL,
      1,
      NULL,
      0.195961,
      1,
      NULL,
      NULL,
      1.805335,
      3.789098,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.843167,
      1.361519,
      NULL,
      5,
      2,
      5,
      2,
      3.443530,
      0.641234,
      5.574488,
      2.154627,
      NULL,
      0,
      1.647103,
      0,
      NULL,
      NULL,
      7,
      1.006276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1.820631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1.805155,
      1,
      NULL,
      NULL,
      NULL,
      2.859079,
      1.154127,
      4.539660,
      NULL,
      0.751495,
      1,
      1.806545,
      NULL,
      NULL,
      NULL,
      1.830065,
      0,
      1.579590,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.780438,
      2.001962,
      NULL,
      1.861298,
      0,
      1.231821,
      NULL,
      2.811838,
      0.680571,
      0,
      1.010160,
      1,
      NULL,
      1,
      1,
      1,
      0.981256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.235892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '11203',
      '02031',
      NULL,
      0,
      '',
      '',
      '',
      3.760508,
      '32242',
      '',
      NULL,
      NULL,
      0.009970,
      3,
      3,
      0.315784,
      1,
      0,
      NULL,
      NULL);
commit;
end;
/


