set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-11-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2133',
      NULL,
      61,
      52,
      '4001333',
      125.536881,
      4,
      0.433485,
      NULL,
      '224142',
      5,
      '11-22-1985',
      60,
      29.371708,
      0.671870,
      NULL,
      NULL,
      2,
      0.277037,
      0,
      0,
      1.177364,
      0.660317,
      3,
      1.422441,
      0.517995,
      0.485939,
      NULL,
      NULL,
      0,
      0,
      0,
      1.564918,
      1.197017,
      0,
      1.878830,
      1.396655,
      NULL,
      3.280855,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228878,
      1,
      NULL,
      1.278384,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.328520,
      0.688235,
      3.801242,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.916935,
      NULL,
      0,
      0,
      0.269983,
      1.696855,
      1,
      1,
      1,
      NULL,
      0,
      0.050684,
      0.971369,
      0.607405,
      0.383875,
      0.179104,
      1.924033,
      NULL,
      NULL,
      1.109275,
      NULL,
      1,
      0,
      1,
      0.680283,
      0,
      1.002031,
      1,
      0.729076,
      1,
      0.015948,
      1.229469,
      0,
      0,
      1,
      1,
      0,
      3.843674,
      2.940411,
      2,
      6,
      NULL,
      0,
      4,
      1.868780,
      0.237974,
      1,
      NULL,
      NULL,
      NULL,
      8.519298,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.606576,
      NULL,
      1,
      1,
      0.899690,
      0,
      1.047061,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.383953,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.561492,
      NULL,
      1.740890,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.603523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.794777,
      1,
      2.945896,
      0.433708,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0.893110,
      1,
      0,
      1,
      NULL,
      0,
      0.948003,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.723821,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      '04143',
      '',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      '40403',
      '',
      '',
      2,
      NULL,
      0.629054,
      3.105887,
      3,
      NULL,
      0,
      1.288980,
      NULL);
commit;
end;
/


