set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9521886';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-4-18 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0130',
      '32012413',
      NULL,
      87,
      '1130001',
      51.710746,
      4,
      1,
      0,
      '230212',
      2.667285,
      ' 8-28-1985',
      46.966220,
      NULL,
      0.305507,
      NULL,
      0,
      0,
      3,
      0.230148,
      0,
      0.057610,
      0.616530,
      1.724135,
      NULL,
      0,
      5.394945,
      1,
      0,
      1,
      NULL,
      1,
      5.764036,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      0.203777,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.334040,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.900598,
      0,
      1,
      0.886798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.390185,
      0.844353,
      0.906056,
      1.731770,
      0,
      NULL,
      1,
      0.376219,
      1,
      1.933880,
      0.646981,
      0,
      0.815117,
      NULL,
      1,
      0.160513,
      0.153864,
      1.618513,
      NULL,
      1,
      0.207936,
      1,
      1,
      0.333591,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.778614,
      0,
      NULL,
      5.584109,
      4.172295,
      0,
      1,
      11.968591,
      5,
      3.552532,
      1,
      1.966314,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.357575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853450,
      NULL,
      1,
      1,
      1,
      0.200839,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.924103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962169,
      0,
      3,
      0.239038,
      3.899236,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494674,
      1.675962,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.609548,
      2,
      1.206137,
      1.294205,
      1.605182,
      1,
      1,
      NULL,
      NULL,
      1,
      1.482042,
      0,
      NULL,
      1.891851,
      0.972851,
      NULL,
      NULL,
      1.559616,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.486619,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '31401',
      '',
      '',
      0.784976,
      NULL,
      3,
      0,
      0,
      NULL,
      1.611074,
      NULL,
      3);
commit;
end;
/


