set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-6-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      NULL,
      7.673815,
      39.434000,
      NULL,
      6.993429,
      2,
      NULL,
      3,
      '301411',
      4,
      ' 5-21-2000',
      18,
      39.493168,
      1.848020,
      NULL,
      NULL,
      NULL,
      NULL,
      0.994218,
      1.237761,
      1,
      1,
      0.680318,
      NULL,
      NULL,
      5.658564,
      NULL,
      NULL,
      NULL,
      0.440989,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1.794841,
      0,
      3,
      2.171463,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.593051,
      1.201083,
      1,
      1.843868,
      0.194313,
      1.886552,
      2.273936,
      3.976118,
      3.002945,
      3,
      2.611860,
      3,
      1,
      2,
      0.672435,
      NULL,
      1.031142,
      3.829992,
      NULL,
      0,
      1,
      0,
      1,
      1,
      1,
      3.300058,
      0.386609,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.402132,
      0.823897,
      1.266447,
      0,
      1,
      6.782773,
      0.177495,
      NULL,
      0,
      5,
      1,
      1.399234,
      2,
      0,
      1.676747,
      NULL,
      NULL,
      0.802557,
      NULL,
      NULL,
      0.929480,
      5,
      3.816712,
      1.478804,
      NULL,
      0.885636,
      1,
      4,
      1,
      1.248628,
      NULL,
      2.401388,
      NULL,
      NULL,
      1,
      NULL,
      8,
      5,
      5,
      1,
      8.493628,
      9,
      0,
      8,
      0,
      0.047502,
      3.929301,
      NULL,
      0,
      2.465568,
      4,
      1.435208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.877887,
      NULL,
      0,
      1,
      0.371805,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980094,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378283,
      0.664991,
      0,
      NULL,
      NULL,
      NULL,
      0.008415,
      0,
      NULL,
      2,
      0.337713,
      0,
      1.829388,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.775088,
      1,
      0,
      0,
      0,
      1,
      1.425631,
      NULL,
      0,
      3,
      0.531476,
      2.686977,
      NULL,
      0.195136,
      0.795406,
      0.109085,
      0,
      1.397767,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      2.911875,
      3.209424,
      1,
      1,
      1.405834,
      0.078506,
      NULL,
      0.526946,
      1.127300,
      NULL,
      1,
      0.832909,
      1,
      0,
      1.890185,
      NULL,
      NULL,
      1.976081,
      0.216563,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.935559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.692162,
      NULL,
      NULL,
      NULL,
      NULL,
      1.011449,
      NULL,
      2,
      6,
      3,
      0,
      0.983218,
      2,
      6.502164,
      '44022',
      '20114',
      '03243',
      0.918484,
      '',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1.921838,
      3.842182,
      1.556590,
      4.741609,
      2,
      0,
      2.776419,
      1.713925,
      0);
commit;
end;
/


