set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-1-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '130',
      '31302121',
      NULL,
      50.322755,
      '0032440',
      25,
      5,
      3.836685,
      1,
      '214201',
      5,
      ' 7-21-2003',
      8.026865,
      7.855772,
      1,
      NULL,
      NULL,
      0.729655,
      0,
      0.857051,
      1,
      2.960938,
      0.725828,
      0.571173,
      1.372687,
      0.870535,
      2,
      NULL,
      9,
      NULL,
      0,
      1,
      3.350985,
      0,
      0,
      1.163516,
      NULL,
      1.908138,
      4.925353,
      1,
      NULL,
      1.796869,
      2.851665,
      1.500259,
      NULL,
      NULL,
      1.735698,
      NULL,
      NULL,
      4.966328,
      7.261526,
      1,
      0,
      1,
      0,
      2,
      0.197654,
      NULL,
      2,
      2,
      1.453333,
      3,
      1.165579,
      0,
      1,
      2.104538,
      3,
      1,
      0.963981,
      0.181106,
      5,
      6.356753,
      0,
      0,
      5.262438,
      0,
      NULL,
      NULL,
      1.681223,
      NULL,
      NULL,
      0,
      NULL,
      5.205769,
      0.621789,
      5,
      NULL,
      11.375067,
      7.300955,
      6.829205,
      NULL,
      7.608731,
      2,
      1,
      4.118193,
      0.637272,
      NULL,
      1.912189,
      1.866201,
      0,
      NULL,
      0.990163,
      5.178454,
      6.636175,
      4.383241,
      0,
      1.294795,
      NULL,
      NULL,
      1,
      NULL,
      0,
      7,
      2.283882,
      1,
      5,
      6,
      8.341992,
      9.424867,
      6.905411,
      8.765541,
      3,
      6,
      NULL,
      8,
      4,
      5,
      0,
      NULL,
      2.487010,
      0,
      1.630087,
      5.412065,
      0.844697,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.948812,
      NULL,
      2,
      0,
      0,
      1.614346,
      NULL,
      0.486026,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.239324,
      NULL,
      NULL,
      NULL,
      NULL,
      0.087426,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.231103,
      1.494298,
      0,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      0.755680,
      3.861093,
      0,
      2,
      0.565687,
      NULL,
      NULL,
      NULL,
      1,
      7.105706,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.106527,
      0.740643,
      3,
      1.033298,
      NULL,
      1.266940,
      2.266232,
      0,
      2,
      1.560308,
      1.357396,
      3.775532,
      NULL,
      1,
      1.341190,
      0.250138,
      NULL,
      1.759624,
      3,
      0,
      2.866702,
      3.910794,
      0.738318,
      3,
      2,
      3.031215,
      1,
      1.527136,
      1.269822,
      NULL,
      0.851760,
      0,
      1.835499,
      0.300395,
      1.383550,
      0.556229,
      1.738368,
      0.134155,
      1,
      NULL,
      0,
      3.256007,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.730764,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769639,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.603900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.513786,
      1.703196,
      1,
      0,
      0,
      1,
      NULL,
      '21202',
      NULL,
      '24221',
      1,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      5.807450,
      NULL,
      2.364802,
      0,
      0.892551,
      3,
      0.968052,
      0);
commit;
end;
/


