set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-6-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '040',
      '13332122',
      NULL,
      14,
      '0334212',
      9,
      0,
      2,
      2,
      '020041',
      NULL,
      ' 8-10-1981',
      17.301052,
      14,
      1.026661,
      NULL,
      4.087332,
      1,
      1,
      1.513948,
      0,
      NULL,
      1,
      1,
      NULL,
      0.531740,
      NULL,
      1,
      NULL,
      NULL,
      0.785673,
      0,
      5.182990,
      NULL,
      0,
      1.395047,
      NULL,
      1.995151,
      7.699322,
      1,
      1.430696,
      0,
      1,
      0,
      NULL,
      NULL,
      0.840290,
      NULL,
      NULL,
      1.212345,
      5.866829,
      7.813285,
      1,
      NULL,
      1,
      3,
      0.428372,
      2,
      0,
      3.121618,
      1,
      3.852978,
      1.045457,
      NULL,
      2.424620,
      0,
      0.286131,
      3.241196,
      0.792762,
      1,
      NULL,
      5.020121,
      1,
      0,
      NULL,
      0.524249,
      NULL,
      NULL,
      0.497792,
      NULL,
      NULL,
      NULL,
      3.962660,
      1,
      NULL,
      NULL,
      2.628222,
      NULL,
      2,
      3,
      1,
      7.206812,
      1.207521,
      NULL,
      6.175092,
      1,
      NULL,
      1,
      1.171183,
      NULL,
      NULL,
      0,
      5.546567,
      8.034595,
      2.186776,
      0.270668,
      NULL,
      3.389996,
      1,
      0.142605,
      0,
      2,
      4.435197,
      2.316352,
      0.258998,
      5.991992,
      2,
      6,
      3.856851,
      0,
      8.178522,
      4,
      8,
      5,
      8.919882,
      9.036338,
      0.389219,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641258,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1.669513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      2.115122,
      1.772758,
      NULL,
      NULL,
      NULL,
      1,
      0.173020,
      4,
      0.075635,
      1.484626,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.829993,
      7.251272,
      1.219474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.826575,
      NULL,
      2,
      1.487676,
      1,
      2.859410,
      1.999973,
      2.042336,
      1.821780,
      NULL,
      1.180660,
      1,
      1.708452,
      0.259942,
      1.038309,
      1,
      1,
      0.027864,
      1,
      2,
      1.827824,
      0,
      1.201294,
      1.178622,
      0.082641,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      0.808888,
      0.917170,
      NULL,
      NULL,
      1.814354,
      0.506709,
      0.485946,
      1.394994,
      NULL,
      NULL,
      NULL,
      2,
      0.515643,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.337111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.471788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.979667,
      NULL,
      NULL,
      NULL,
      1.472725,
      NULL,
      1.660691,
      NULL,
      '03034',
      '22240',
      1.318429,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      3,
      3.984254,
      0.107216,
      1.071627,
      8,
      0.839284,
      1,
      2,
      2.596779);
commit;
end;
/


