set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-12-21 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '232',
      '03230020',
      NULL,
      61.234307,
      '2130002',
      14,
      NULL,
      1.954450,
      0,
      '102112',
      NULL,
      ' 5- 5-1976',
      58.145120,
      10,
      0,
      NULL,
      NULL,
      0,
      1.768442,
      1.523055,
      1,
      2,
      1.704361,
      NULL,
      0.432662,
      1.836749,
      NULL,
      1.223767,
      NULL,
      0,
      NULL,
      0.119052,
      8.128250,
      1,
      1,
      0,
      0,
      0.846862,
      5.392868,
      0,
      NULL,
      3.695097,
      3.089641,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.560484,
      0.637931,
      9,
      0,
      0.277484,
      1,
      1,
      2,
      1,
      1.640256,
      2,
      1.321796,
      1,
      2,
      0.655238,
      0.871302,
      0,
      1,
      2.279935,
      0,
      0,
      0.654495,
      NULL,
      0,
      1,
      4.458871,
      1.177550,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      7.828806,
      0,
      4,
      NULL,
      2,
      4,
      0,
      0,
      7,
      NULL,
      2,
      1.298565,
      2.963400,
      1,
      1,
      1.926867,
      0.852687,
      0.395454,
      NULL,
      1,
      0.400453,
      3.470355,
      1.751720,
      3,
      0,
      1,
      1.186387,
      NULL,
      1.726832,
      1,
      1.012607,
      2,
      NULL,
      1,
      3.091356,
      NULL,
      8.367283,
      1,
      5,
      7,
      6.547783,
      9,
      NULL,
      NULL,
      5,
      3,
      0,
      0.453205,
      0.288494,
      0.410391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.418224,
      1,
      1.269784,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.530313,
      NULL,
      NULL,
      NULL,
      NULL,
      2.010084,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.159820,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.131886,
      4,
      1.967394,
      0,
      2,
      0.874787,
      NULL,
      NULL,
      NULL,
      0,
      7.313299,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2.511871,
      1.075502,
      3,
      NULL,
      2,
      1,
      3,
      0,
      1.753028,
      3,
      1.389030,
      0,
      0,
      1.556197,
      0,
      1.476087,
      3,
      0,
      1.164845,
      0,
      0.978093,
      2,
      NULL,
      3.971803,
      0.809272,
      1.990046,
      1.067540,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      0.897905,
      0,
      1.071829,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.746617,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.226333,
      6.658646,
      3.780452,
      0.691221,
      NULL,
      NULL,
      2.721584,
      '42120',
      '44420',
      '30321',
      0,
      '',
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      2.117701,
      1.783624,
      0.899688,
      1.195623,
      7,
      5,
      3.333504,
      NULL,
      NULL);
commit;
end;
/


