set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4020',
      '33241131',
      31,
      71,
      '0242420',
      59.908368,
      0,
      3,
      3,
      '023222',
      1,
      '11-23-1995',
      NULL,
      44,
      1,
      NULL,
      1.656464,
      1,
      NULL,
      1.087192,
      1,
      3.541774,
      1.944562,
      2.569601,
      NULL,
      0,
      NULL,
      1.704953,
      0,
      2.419943,
      0,
      NULL,
      4,
      0,
      1,
      0,
      0.600128,
      0.314541,
      3.771751,
      0,
      5.713190,
      0,
      3,
      1.427586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      8,
      9,
      1,
      1.819902,
      1,
      2,
      NULL,
      1,
      2,
      0,
      1,
      2,
      1,
      0.971453,
      2.959273,
      0.310450,
      NULL,
      2.353314,
      0,
      0.752271,
      NULL,
      4.715020,
      0,
      2,
      5.287395,
      1.156527,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      6.243712,
      2.943790,
      1,
      0.411064,
      0.970001,
      6,
      3.662174,
      1.632769,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.944342,
      0,
      NULL,
      0.402989,
      0.266809,
      NULL,
      0,
      3,
      7,
      6.264241,
      2.868812,
      1.707081,
      NULL,
      1,
      2.295277,
      0,
      0.604704,
      4,
      1.552958,
      1,
      3,
      NULL,
      1,
      6,
      4,
      5,
      1,
      NULL,
      NULL,
      3,
      2,
      4,
      NULL,
      4.454932,
      0.529255,
      NULL,
      1.412644,
      4,
      0.372249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.515790,
      1,
      1,
      0.604338,
      1.477805,
      5,
      0.138578,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856272,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.920109,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      9,
      1.710025,
      4,
      4.579247,
      0,
      1,
      0.264389,
      NULL,
      NULL,
      NULL,
      NULL,
      4.051552,
      1.323166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.700844,
      1.418783,
      3.114290,
      0,
      2.894010,
      2.708190,
      0,
      3,
      1.232525,
      1.148240,
      NULL,
      0.385860,
      0.906203,
      NULL,
      0,
      1,
      0,
      1,
      0,
      0,
      0.063770,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1.781317,
      0,
      1,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      1.652800,
      NULL,
      1.235099,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.679839,
      0,
      1,
      0.223146,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588469,
      NULL,
      NULL,
      NULL,
      NULL,
      1.950610,
      1,
      1.808454,
      NULL,
      0.998149,
      3,
      0,
      NULL,
      7.820335,
      1,
      0.828412,
      NULL,
      0,
      6.452061,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      5.436702,
      1,
      1.043101,
      0.816636,
      5,
      0,
      0,
      NULL);
commit;
end;
/


