set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-12-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34013421',
      NULL,
      26,
      '1300334',
      38,
      2,
      NULL,
      2,
      '102210',
      4,
      ' 9- 2-1978',
      35.485166,
      202,
      0.673623,
      NULL,
      0,
      1,
      0.676182,
      NULL,
      1.327053,
      0.659999,
      2,
      2,
      1.841866,
      1,
      6,
      NULL,
      1.145124,
      2,
      1.077595,
      1.046134,
      11,
      1.035970,
      0.728335,
      NULL,
      1.809353,
      0.960291,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.785131,
      NULL,
      NULL,
      3,
      9.019466,
      6.303709,
      1,
      0,
      1,
      3.530922,
      3,
      1,
      2.461752,
      NULL,
      0,
      NULL,
      3.902786,
      1,
      1.792513,
      0,
      0,
      NULL,
      NULL,
      0,
      0,
      6,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      7.155167,
      NULL,
      3.092989,
      4.766852,
      NULL,
      NULL,
      0.372688,
      0,
      1.824749,
      2,
      NULL,
      1,
      6.407252,
      0.534343,
      0.417845,
      1.192978,
      NULL,
      1,
      NULL,
      NULL,
      3.778968,
      5,
      6.011552,
      2,
      NULL,
      2,
      1.384737,
      1.184570,
      1.540286,
      0.715783,
      NULL,
      1,
      1.278364,
      2.925830,
      0,
      3.277843,
      NULL,
      2,
      2.267726,
      2.923952,
      NULL,
      3,
      1,
      6,
      2,
      3.546461,
      7,
      2,
      NULL,
      NULL,
      5.443016,
      0.159575,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.103209,
      2,
      2,
      1,
      4.550491,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.191503,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.062868,
      1.741220,
      1,
      2.694716,
      0.545191,
      NULL,
      2.065114,
      0,
      1,
      3,
      1.902379,
      2,
      2.045626,
      NULL,
      NULL,
      NULL,
      0.285531,
      9.620119,
      0.313510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.734647,
      3.279176,
      2,
      2,
      NULL,
      0,
      NULL,
      3,
      2.733904,
      3.030414,
      NULL,
      1.653814,
      1.186037,
      0,
      0,
      0.097680,
      1,
      0,
      0,
      2.221839,
      1,
      0.521363,
      0.137116,
      3.866536,
      3,
      0.518673,
      NULL,
      0.921294,
      NULL,
      0.034285,
      0.435309,
      0.066538,
      NULL,
      1,
      1,
      0,
      0,
      1.361027,
      0.328763,
      0,
      3,
      0.564311,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.138561,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704608,
      NULL,
      NULL,
      NULL,
      NULL,
      0.657908,
      3.038991,
      1.014894,
      8,
      3,
      NULL,
      NULL,
      NULL,
      2.568538,
      '20003',
      '01224',
      '40103',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      1,
      NULL,
      0,
      4.173144,
      NULL,
      0,
      NULL,
      5.171641,
      1.348605);
commit;
end;
/


