set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0401',
      '02140422',
      NULL,
      NULL,
      '3304402',
      50.908400,
      NULL,
      2.915764,
      2,
      '421443',
      1.836343,
      ' 0-17-1994',
      NULL,
      34,
      1,
      NULL,
      1,
      2,
      1,
      0.001914,
      0.225340,
      1.210923,
      3,
      1.624548,
      NULL,
      1,
      5.119322,
      0.189518,
      0.147345,
      2,
      0.233812,
      1.777802,
      6.682892,
      0.775602,
      0,
      1,
      1,
      1.548115,
      0.720168,
      0,
      NULL,
      NULL,
      2.905515,
      1.967165,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.069215,
      NULL,
      NULL,
      1.919127,
      1.837040,
      1,
      3.131598,
      3.491242,
      1,
      1,
      NULL,
      0.452076,
      NULL,
      NULL,
      NULL,
      3.228518,
      0,
      0,
      3,
      1,
      0.102134,
      2,
      6,
      0,
      NULL,
      0.197285,
      0.629754,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      5,
      3,
      3,
      1.988528,
      5.512294,
      0,
      1.216024,
      0,
      NULL,
      3.649126,
      1,
      NULL,
      3.961410,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      2.985322,
      0,
      NULL,
      7,
      1.716443,
      1.160659,
      3,
      NULL,
      0.702165,
      1,
      3.483647,
      0.822641,
      NULL,
      6,
      NULL,
      8.035320,
      8,
      NULL,
      2.951513,
      7.500973,
      9.802560,
      3,
      4,
      NULL,
      0,
      1.099055,
      0.107894,
      0.766395,
      0.723584,
      4.817846,
      1.930886,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.225462,
      0,
      1,
      1,
      0,
      0.237100,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      1.602436,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      1.735623,
      NULL,
      NULL,
      NULL,
      5.805161,
      1.646451,
      NULL,
      4.564628,
      1,
      1,
      9.937443,
      0.007834,
      3,
      1,
      NULL,
      7,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.401093,
      2.308902,
      0,
      2.398518,
      2.455408,
      3,
      NULL,
      3.539306,
      2,
      1,
      2.608900,
      NULL,
      0,
      NULL,
      0.254912,
      0,
      1.736957,
      1,
      1.629434,
      1.924494,
      2,
      1.980947,
      1.842858,
      0.078849,
      0.045442,
      1.101537,
      1,
      1.641476,
      0,
      0,
      0.819042,
      1,
      1,
      1.662579,
      1,
      NULL,
      0.165241,
      0,
      0.517755,
      0.147075,
      0,
      NULL,
      0.837552,
      1.855944,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.474908,
      2.906176,
      2.465977,
      8,
      1,
      0.776650,
      1,
      2,
      0.571173,
      '20423',
      '20110',
      '40034',
      NULL,
      '',
      '',
      NULL,
      1.878160,
      '',
      '',
      NULL,
      5,
      1.252535,
      1.302800,
      NULL,
      3.646805,
      2,
      0.506340,
      1.609406,
      2);
commit;
end;
/


