set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-12-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0104',
      '02301121',
      NULL,
      51,
      '3214130',
      NULL,
      5,
      3.661121,
      3,
      '101211',
      NULL,
      ' 2-18-1977',
      40.527551,
      7.207697,
      0,
      NULL,
      1,
      0,
      0.520473,
      0.285928,
      1.657038,
      0,
      NULL,
      NULL,
      1.141174,
      NULL,
      NULL,
      0.043957,
      1,
      0.377836,
      0.463997,
      0,
      6,
      0.163383,
      0.309291,
      0.134528,
      NULL,
      0,
      3.669717,
      0,
      0,
      NULL,
      3,
      0,
      NULL,
      NULL,
      0.482920,
      NULL,
      NULL,
      10,
      0,
      0.334783,
      0.321182,
      1,
      1.984290,
      0.086855,
      2,
      NULL,
      0.471049,
      0,
      NULL,
      0.743249,
      3.433140,
      1,
      NULL,
      2.471925,
      2,
      1,
      1.226516,
      1.317876,
      0.529486,
      NULL,
      1,
      NULL,
      0.321861,
      0.949116,
      NULL,
      NULL,
      0.556963,
      NULL,
      NULL,
      2,
      1.621874,
      6.579383,
      3,
      0,
      6,
      3,
      1,
      1.645015,
      5,
      NULL,
      6.475834,
      0,
      NULL,
      0,
      NULL,
      0,
      0.435907,
      NULL,
      NULL,
      0.847956,
      8.772488,
      1.866428,
      7,
      7,
      NULL,
      5.102900,
      NULL,
      1.403566,
      NULL,
      1.810719,
      4.151909,
      2.941589,
      NULL,
      7,
      0,
      9,
      9,
      NULL,
      NULL,
      7.870901,
      0.288397,
      7,
      0.045521,
      5,
      NULL,
      3.029900,
      0,
      0,
      1,
      0,
      7,
      0.417761,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      0,
      7.934791,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.553185,
      NULL,
      3,
      1.874736,
      3.703679,
      1,
      0,
      0.898519,
      0.306324,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.511209,
      0.902608,
      NULL,
      5.229549,
      2.493015,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      7.924030,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.731770,
      2,
      1,
      NULL,
      0,
      1.409226,
      0,
      NULL,
      NULL,
      2.938260,
      3,
      0,
      NULL,
      1,
      1.919205,
      0.285475,
      1.240367,
      0.589596,
      NULL,
      NULL,
      0,
      3,
      1,
      1,
      NULL,
      3.024628,
      1.596717,
      0.709999,
      1,
      1,
      0.074111,
      0.357550,
      1,
      2.708927,
      3,
      0.397683,
      0.775797,
      1.341594,
      1.717758,
      1.366671,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.730347,
      2,
      5,
      3.996527,
      0.454659,
      0,
      1,
      NULL,
      NULL,
      '02020',
      NULL,
      0,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.972454,
      NULL,
      2.802852,
      0,
      2,
      2,
      NULL,
      1,
      0);
commit;
end;
/


