set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9810199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-7-11 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4304',
      '23231134',
      58.650808,
      88.388048,
      '3010443',
      72.120147,
      NULL,
      NULL,
      2,
      NULL,
      3.131943,
      NULL,
      43,
      78.708991,
      0,
      NULL,
      3,
      0,
      1.445766,
      1.562904,
      0.420895,
      3,
      2,
      3,
      0,
      1.503946,
      5,
      0.130469,
      1.854689,
      NULL,
      0.087972,
      3.531512,
      NULL,
      1,
      0.467510,
      1,
      0.112273,
      NULL,
      NULL,
      NULL,
      1.952388,
      3.358564,
      1.276070,
      0,
      NULL,
      NULL,
      0.428343,
      NULL,
      NULL,
      NULL,
      6,
      0,
      0,
      NULL,
      NULL,
      1.954481,
      3,
      1,
      2,
      1,
      1.004509,
      NULL,
      1.782434,
      1.559786,
      NULL,
      1.610651,
      0,
      3.847779,
      1.767569,
      0.608325,
      0.696244,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.926477,
      3,
      4.305258,
      2.411032,
      3.351980,
      7.582026,
      4.530372,
      0,
      0,
      1,
      1,
      1,
      NULL,
      6,
      1.148262,
      0,
      1,
      1,
      1.347252,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.588819,
      NULL,
      1.405329,
      1.751119,
      3,
      NULL,
      1,
      8,
      NULL,
      6,
      3.575296,
      0.784535,
      1.421224,
      8,
      NULL,
      1,
      6,
      5.281721,
      NULL,
      7,
      8,
      0.827257,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      0.234437,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2,
      NULL,
      3,
      4,
      0.796975,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.962997,
      0.154745,
      1,
      2.180224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.194826,
      0.884201,
      NULL,
      NULL,
      NULL,
      6.451422,
      0,
      4,
      NULL,
      0,
      NULL,
      1.677823,
      NULL,
      NULL,
      NULL,
      1,
      7.001718,
      0.460144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.918929,
      3,
      1,
      0.733930,
      2.105913,
      1.422056,
      0.348138,
      0.707919,
      2.800744,
      0.700604,
      0,
      1.654699,
      1.118546,
      NULL,
      0,
      0.839992,
      0.965608,
      0,
      0.645115,
      NULL,
      1.555647,
      0,
      1,
      1.944851,
      NULL,
      0.702603,
      1.391333,
      1,
      NULL,
      0.071449,
      1.926983,
      0,
      1.410932,
      NULL,
      1.224616,
      0.371359,
      1,
      0.173827,
      1.497455,
      0.117936,
      NULL,
      1.307803,
      2.654811,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.508246,
      1.959660,
      NULL,
      1,
      0,
      0.651061,
      0.634661,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.167697,
      NULL,
      0.139065,
      1,
      1,
      1,
      1,
      1,
      '13333',
      '24242',
      NULL,
      1.761012,
      '',
      NULL,
      '',
      1.028124,
      '',
      '',
      '',
      5,
      5.860099,
      NULL,
      2.744238,
      1.170953,
      2,
      2,
      NULL,
      NULL);
commit;
end;
/


