set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-5-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '224',
      '12024444',
      13.307957,
      60.529792,
      NULL,
      1.812774,
      2,
      1,
      3,
      '210442',
      3.189006,
      '11-26-1977',
      45.752760,
      36.923653,
      NULL,
      NULL,
      0.170950,
      NULL,
      1.368607,
      0,
      1.810614,
      1.203211,
      1,
      0,
      0,
      1.054924,
      NULL,
      1.997388,
      0.797246,
      2,
      NULL,
      NULL,
      0.312315,
      1.007745,
      NULL,
      1,
      0.300474,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.872804,
      1.376029,
      1,
      1.272158,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      5.745579,
      NULL,
      NULL,
      2,
      4.670705,
      1,
      0,
      NULL,
      1.221190,
      1,
      0.753276,
      1,
      1.323937,
      1.035877,
      1.991403,
      1.023916,
      0.274700,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.605388,
      1.057256,
      0.801310,
      NULL,
      3,
      1.407703,
      1.047342,
      0,
      1.785112,
      1.731206,
      5.364064,
      0.733594,
      3,
      NULL,
      6.010913,
      2.945556,
      NULL,
      10.129094,
      NULL,
      2.604408,
      6.480458,
      5,
      0.934824,
      1.104571,
      0,
      NULL,
      NULL,
      4.180958,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.850038,
      NULL,
      NULL,
      1,
      0.760757,
      1.953633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.751241,
      NULL,
      6,
      1,
      0.343652,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.313827,
      NULL,
      5.634088,
      NULL,
      NULL,
      7.634553,
      NULL,
      0,
      1.943550,
      0.708310,
      NULL,
      NULL,
      1,
      9.415952,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.242749,
      NULL,
      NULL,
      1,
      2.530272,
      3,
      0.732533,
      NULL,
      1,
      NULL,
      2.126928,
      0,
      1.323999,
      NULL,
      1,
      1.316873,
      0,
      0,
      0,
      1.696246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.963841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      '22410',
      '',
      '',
      1,
      '',
      '',
      '',
      0.365381,
      '0132',
      '',
      '',
      4.365333,
      0.762858,
      2.120517,
      1,
      3,
      NULL,
      3.719549,
      0.553759,
      3.151800);
commit;
end;
/


