set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-11-08 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '032',
      '31012242',
      13.780877,
      25.721283,
      '2101234',
      16,
      2,
      1.146073,
      NULL,
      '232112',
      6.059257,
      ' 8-10-1993',
      45.331682,
      NULL,
      1.882879,
      NULL,
      0.778069,
      0,
      0.607307,
      0,
      0.309154,
      2.346657,
      0.869849,
      1,
      0.997541,
      1,
      1.552192,
      0.479830,
      NULL,
      0,
      1.719496,
      0.854533,
      1,
      1,
      0.815987,
      0.466415,
      0.932640,
      1.325524,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.644708,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.501621,
      NULL,
      0.135148,
      1.117771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368603,
      0,
      0.490100,
      2.218129,
      NULL,
      2,
      NULL,
      1,
      0,
      1.879698,
      0,
      1,
      NULL,
      2.649863,
      0,
      1.394582,
      0.248403,
      1,
      0.158750,
      NULL,
      1.297840,
      5,
      NULL,
      0.038418,
      1.936031,
      NULL,
      5,
      1,
      0.903731,
      NULL,
      2.276709,
      NULL,
      NULL,
      1,
      0.882872,
      NULL,
      5.007436,
      4.404396,
      0,
      2.010547,
      9,
      2.302865,
      5,
      9.145483,
      NULL,
      1,
      0.706925,
      NULL,
      0.051554,
      NULL,
      NULL,
      3.594033,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      1.713995,
      NULL,
      1.394331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.798332,
      NULL,
      8.298837,
      2,
      0.277251,
      4,
      NULL,
      0,
      NULL,
      1.938742,
      1.633219,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      1,
      5.297198,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.361018,
      0.513088,
      0.047960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.146194,
      0.976377,
      1.824280,
      0.997435,
      0,
      1,
      1.805448,
      2,
      1.225879,
      0,
      0,
      0,
      1,
      NULL,
      0.050855,
      1,
      1,
      NULL,
      1.825072,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '20243',
      '',
      '',
      0,
      NULL,
      '',
      '',
      0,
      '',
      '',
      NULL,
      4.371431,
      2,
      0,
      0.031393,
      1,
      3,
      2.841434,
      3.204919,
      1.504864);
commit;
end;
/


