set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-11-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1123',
      '34423431',
      35.343402,
      30,
      '3240224',
      NULL,
      5,
      0.630171,
      0,
      NULL,
      0.333058,
      NULL,
      NULL,
      6,
      0,
      NULL,
      0,
      1,
      NULL,
      1.051133,
      1,
      3,
      1,
      0,
      1.202549,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0.783450,
      NULL,
      0,
      1.319695,
      NULL,
      0.186165,
      NULL,
      0,
      NULL,
      0.040105,
      1.616717,
      NULL,
      NULL,
      1.669295,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.951593,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.780645,
      4.806831,
      1,
      3,
      1,
      1.444904,
      NULL,
      NULL,
      1.438853,
      0.039912,
      0,
      1.622441,
      NULL,
      1.792081,
      NULL,
      1.928204,
      1.534062,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      3.423334,
      0.065267,
      4.097067,
      1,
      NULL,
      0.471731,
      NULL,
      NULL,
      NULL,
      1.963811,
      0,
      4.666379,
      6.785559,
      8.813864,
      5.412887,
      2.635389,
      4,
      NULL,
      NULL,
      0,
      3.646657,
      2.612184,
      2.838945,
      4.853471,
      NULL,
      NULL,
      1,
      3.145976,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.808259,
      0,
      0,
      1.857660,
      0,
      0.788262,
      0.413824,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.454670,
      NULL,
      NULL,
      NULL,
      NULL,
      0.322264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.760030,
      1.122945,
      0.038715,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.415432,
      2,
      0,
      3,
      NULL,
      0.667559,
      1,
      1,
      3,
      0,
      1.145455,
      1.893087,
      0,
      1.848865,
      1.165896,
      0.448732,
      1,
      0,
      0.376302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.769569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.234510,
      '22024',
      '',
      '',
      0.174453,
      '',
      '',
      '',
      1.784749,
      '',
      '',
      '',
      1.747105,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      0.006685,
      3.834432);
commit;
end;
/


