set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-5-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0122',
      NULL,
      27,
      28.654803,
      '3010233',
      53.395868,
      6,
      1,
      3,
      '144304',
      2.115115,
      NULL,
      19.630727,
      3,
      0.502004,
      NULL,
      3,
      0,
      3,
      NULL,
      1,
      3,
      NULL,
      0.301233,
      NULL,
      0.694901,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      1.378597,
      1.836197,
      1,
      1.055354,
      0.491770,
      4.662854,
      NULL,
      NULL,
      1.639142,
      1.911605,
      1,
      NULL,
      NULL,
      1.961209,
      NULL,
      NULL,
      0.153993,
      1.933256,
      0.329326,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.942532,
      1,
      1.557327,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.290892,
      0.279448,
      3,
      1.022881,
      7.139892,
      NULL,
      6.885015,
      0.687130,
      4.383132,
      1,
      0.254364,
      NULL,
      1,
      4.175743,
      0,
      1.690807,
      0,
      0,
      1,
      NULL,
      1,
      1,
      2,
      NULL,
      3,
      1.490842,
      NULL,
      NULL,
      4,
      5.756724,
      2.412298,
      NULL,
      NULL,
      0.847421,
      1.713710,
      8.986707,
      3.754881,
      NULL,
      9.037254,
      4.286009,
      7,
      3.446848,
      1.822259,
      9,
      2.968692,
      NULL,
      0.203767,
      4.403942,
      0.767162,
      0,
      1.121204,
      2,
      1.598179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.601113,
      2,
      0,
      0.342468,
      1.340203,
      1.036999,
      1.132736,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.629163,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.795751,
      4,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.528718,
      NULL,
      3,
      NULL,
      0,
      3,
      1,
      0.803546,
      0.090831,
      0,
      0,
      1.191294,
      0.231200,
      1,
      0.174987,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.513689,
      '20204',
      NULL,
      '',
      0.026133,
      '',
      '',
      '',
      1.013003,
      '',
      '',
      '',
      2.125744,
      0,
      3,
      0,
      2.589806,
      3,
      3.439656,
      NULL,
      2.241656);
commit;
end;
/


