set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9416498';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-5-10 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      18.372832,
      '4034123',
      NULL,
      2,
      0,
      2,
      NULL,
      0.733901,
      ' 5-22-1975',
      46,
      7,
      0.742095,
      NULL,
      3.826229,
      NULL,
      1.478515,
      0,
      0,
      1,
      0.083015,
      0,
      NULL,
      1,
      5,
      NULL,
      1,
      1,
      0,
      1,
      3,
      NULL,
      0.354093,
      1.667707,
      1.509141,
      NULL,
      0.610499,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.924492,
      NULL,
      NULL,
      1.189333,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.920208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.193979,
      5.911824,
      NULL,
      1,
      5.550342,
      2,
      4.380927,
      1,
      4,
      1.618031,
      0.944841,
      1,
      3,
      5.006858,
      1,
      0,
      1,
      1.805154,
      1.045525,
      NULL,
      0,
      0.552053,
      5,
      1.341587,
      1,
      1,
      5,
      1,
      3,
      0,
      NULL,
      5.579780,
      2.128593,
      NULL,
      1.355400,
      4,
      4.371311,
      NULL,
      6,
      NULL,
      1.977267,
      2.097857,
      2.854360,
      NULL,
      3.587520,
      4,
      1.674608,
      1.111867,
      1,
      1,
      1.043785,
      1,
      1.338490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.077832,
      NULL,
      NULL,
      NULL,
      NULL,
      2.086524,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.438538,
      0,
      NULL,
      NULL,
      NULL,
      6.614767,
      0,
      1.071044,
      0.480468,
      1.629644,
      2,
      0.518636,
      NULL,
      NULL,
      NULL,
      NULL,
      4.265018,
      0.852880,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.409059,
      1.840882,
      2.297054,
      0.686645,
      0,
      3,
      0.695129,
      3.201643,
      0,
      3.763438,
      3,
      1,
      0,
      0.010688,
      NULL,
      1,
      0,
      1.882290,
      NULL,
      1.158620,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923166,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      '30034',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1.477564,
      '',
      NULL,
      '',
      3,
      NULL,
      NULL,
      3.297225,
      1,
      3,
      1.630848,
      0,
      NULL);
commit;
end;
/


