set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-2-19 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '100',
      NULL,
      14,
      17,
      '1101340',
      179.822414,
      1,
      1.825511,
      1,
      NULL,
      NULL,
      '10-12-1990',
      NULL,
      114,
      1.750676,
      NULL,
      12.524267,
      3.867625,
      NULL,
      NULL,
      3,
      1.405370,
      NULL,
      1,
      0,
      0.309158,
      1.512932,
      NULL,
      0.436281,
      1,
      1.272128,
      0.297151,
      NULL,
      NULL,
      NULL,
      0.372694,
      NULL,
      0.332963,
      0.766091,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.527300,
      0.916553,
      1.957421,
      1.477716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.957103,
      1,
      0,
      0.015959,
      0.309256,
      NULL,
      NULL,
      1,
      0,
      0.980267,
      0.679413,
      1.611482,
      1.186381,
      0.953513,
      1.375748,
      1.370763,
      0.368447,
      1.862755,
      NULL,
      1,
      0.574761,
      0.381422,
      0,
      1.413825,
      NULL,
      1,
      NULL,
      0.020360,
      0.886499,
      0,
      0,
      1.969379,
      NULL,
      0.131208,
      1.396224,
      NULL,
      0.656291,
      5,
      3,
      0,
      0.791634,
      0.454717,
      3.433371,
      0.228555,
      0.113711,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.112763,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.267954,
      NULL,
      NULL,
      1,
      NULL,
      0.758716,
      1.637942,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.645193,
      NULL,
      NULL,
      NULL,
      NULL,
      1.789557,
      1,
      1,
      1.362438,
      0.091903,
      1,
      3.895242,
      2.433091,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      1,
      0.964166,
      NULL,
      NULL,
      NULL,
      0.337468,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.787794,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      1.992131,
      1,
      NULL,
      0,
      0.315362,
      1.042679,
      1.679169,
      NULL,
      0.149960,
      0,
      1.902836,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.658399,
      '24233',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      0,
      NULL,
      '',
      '',
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


