set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-8-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '413',
      '03330430',
      60.672425,
      63.113407,
      '0433234',
      79,
      NULL,
      1.909451,
      3,
      '203340',
      3,
      ' 8- 2-1980',
      10,
      35,
      0,
      NULL,
      NULL,
      1.733709,
      NULL,
      1,
      NULL,
      2,
      0,
      1.812790,
      1,
      1.563748,
      NULL,
      0.057480,
      1.677051,
      0,
      1,
      0,
      3,
      0,
      0,
      0.850790,
      1.830026,
      1.017577,
      1.135102,
      NULL,
      1,
      0,
      NULL,
      0.913769,
      NULL,
      NULL,
      1.466345,
      NULL,
      NULL,
      1.885000,
      1,
      NULL,
      0.041796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.690033,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.534923,
      1.053540,
      0,
      1.990505,
      0.248787,
      1,
      0.418522,
      1,
      1.989992,
      0.656668,
      0,
      1,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      1,
      5.199641,
      NULL,
      1.409313,
      0,
      1,
      5.452679,
      1.774800,
      1,
      1,
      4,
      1.287600,
      0,
      NULL,
      3,
      0.371030,
      0.887876,
      6,
      6,
      NULL,
      2.750839,
      4.957999,
      3.545831,
      9.771037,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      6.334260,
      0.183892,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.350922,
      1,
      0,
      0.885735,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      7,
      2,
      3,
      1.162907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      5.369774,
      NULL,
      0,
      0,
      1.206511,
      1.580624,
      NULL,
      NULL,
      1.819868,
      0.697003,
      0.617423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.935261,
      2.993514,
      0.395747,
      2,
      2.143640,
      1.158328,
      3,
      1.920768,
      NULL,
      0,
      1.690209,
      NULL,
      0,
      0.254328,
      0.973828,
      0,
      1.852604,
      1.580137,
      1.663544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.640063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.579686,
      '01230',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.589769,
      '',
      '',
      '',
      0.945578,
      1,
      3.954430,
      1,
      3.931328,
      0.840275,
      NULL,
      1,
      1.073314);
commit;
end;
/


