set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '344',
      '24233102',
      48.956485,
      23.180779,
      '2042313',
      178.320186,
      NULL,
      1.512540,
      3,
      '000413',
      NULL,
      '10-28-1981',
      37.420985,
      NULL,
      0.810223,
      NULL,
      NULL,
      1.304800,
      3.172981,
      NULL,
      1.359908,
      0.325437,
      1.622202,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.775841,
      0,
      NULL,
      1,
      0,
      NULL,
      1.083487,
      NULL,
      0,
      3.188565,
      0,
      3.902863,
      0.281980,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.628411,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0.986408,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.771466,
      1.049548,
      0.249804,
      0.764805,
      0,
      0.690330,
      1,
      0,
      1,
      1,
      1,
      0.765899,
      0.671144,
      1,
      1,
      0.735770,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.191090,
      1.527014,
      NULL,
      1.335243,
      1.031251,
      NULL,
      0.143625,
      1,
      4.573344,
      5.298767,
      NULL,
      1,
      1,
      4,
      1.692738,
      0,
      4.534547,
      NULL,
      4.995098,
      1.353671,
      NULL,
      0.967392,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1.348329,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.558019,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.998063,
      NULL,
      1.660956,
      NULL,
      NULL,
      NULL,
      0,
      0,
      5,
      1,
      NULL,
      0,
      1.562063,
      NULL,
      NULL,
      NULL,
      1.561747,
      3.494317,
      1.945354,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.387757,
      0,
      1.615934,
      1,
      NULL,
      2,
      1.153688,
      3.581087,
      0,
      NULL,
      0,
      1.107807,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1.243396,
      0.715569,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '31231',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      4.464363,
      NULL,
      3.963956,
      5,
      0,
      1.961553,
      1,
      0,
      3.294679);
commit;
end;
/


