set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3102',
      '42024440',
      56,
      NULL,
      NULL,
      NULL,
      4,
      3,
      0,
      '013020',
      2.681475,
      ' 3-16-1976',
      12,
      49,
      0,
      NULL,
      4.670006,
      NULL,
      3,
      1.908806,
      0.017193,
      0.039036,
      NULL,
      0,
      1.560585,
      0.325448,
      0,
      0.844023,
      1,
      0.200764,
      0.950907,
      1,
      2.149135,
      0.913405,
      NULL,
      0.577015,
      NULL,
      0.286580,
      2,
      1,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.016869,
      0.007097,
      0,
      1.221888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.946463,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.202768,
      0.949888,
      NULL,
      0,
      0,
      1,
      0,
      1.201132,
      0,
      0,
      1.047788,
      NULL,
      NULL,
      NULL,
      1.323966,
      1,
      NULL,
      1,
      0.315334,
      NULL,
      1.772267,
      1.285025,
      1.843413,
      0,
      2.684394,
      1,
      4.215018,
      0.998975,
      1,
      2.334093,
      4.599004,
      1.782027,
      0,
      0.916801,
      1,
      0.989860,
      1,
      NULL,
      NULL,
      2,
      1.247041,
      4,
      NULL,
      NULL,
      1.561510,
      NULL,
      0.638541,
      NULL,
      0.929358,
      NULL,
      NULL,
      NULL,
      0.465042,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.700060,
      1.099967,
      0,
      1,
      1,
      0.623643,
      0.283798,
      1.040043,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.153044,
      2.268595,
      1.753817,
      NULL,
      0,
      0,
      0.581628,
      NULL,
      NULL,
      NULL,
      1.322011,
      0.006239,
      NULL,
      NULL,
      NULL,
      0,
      0.081353,
      0.474860,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      5.016585,
      1.699190,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.024602,
      3.238108,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1.399874,
      1.837350,
      3,
      0,
      1.179789,
      0,
      1.572812,
      NULL,
      0,
      NULL,
      0,
      1,
      0.579089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      2,
      NULL,
      '4234',
      '',
      NULL,
      0,
      1,
      1.020804,
      0.639553,
      3,
      3,
      NULL,
      NULL);
commit;
end;
/


