set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023556';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4323',
      NULL,
      83,
      43,
      '4142430',
      65,
      4,
      3.765884,
      3,
      '233341',
      NULL,
      ' 0-23-1995',
      34,
      NULL,
      0,
      NULL,
      NULL,
      0.178042,
      2.854261,
      1,
      1,
      0.327598,
      0.213794,
      1.804534,
      0.990270,
      0,
      4.511501,
      1.140355,
      NULL,
      NULL,
      1.521960,
      0,
      3.523217,
      NULL,
      0.529481,
      0.862014,
      1.744764,
      0.431068,
      5,
      1,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.670106,
      NULL,
      NULL,
      0,
      1.468145,
      1.125469,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.985352,
      NULL,
      0.975208,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.999548,
      0,
      0,
      0.129585,
      1.838312,
      1,
      0,
      0,
      0,
      0,
      0,
      1,
      1.258298,
      1.451943,
      0.600492,
      0,
      1.098727,
      NULL,
      0.512680,
      NULL,
      0,
      5,
      0,
      0,
      0.253019,
      NULL,
      2,
      1.075776,
      5.630015,
      0.724969,
      NULL,
      0.729550,
      0.787028,
      0.019745,
      1,
      0.712309,
      1,
      NULL,
      4,
      6,
      3.619640,
      6,
      1,
      NULL,
      4.522436,
      5.983484,
      8.385783,
      4.846076,
      0,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      0.985829,
      NULL,
      0.040030,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140866,
      NULL,
      0.872367,
      2,
      0.270308,
      3.845329,
      0.868447,
      1.937016,
      NULL,
      0,
      1,
      5,
      2.365400,
      1.263163,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      4.601862,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      3,
      NULL,
      3,
      3.503531,
      1,
      1.407814,
      0.716624,
      NULL,
      0.007722,
      1.256963,
      NULL,
      0,
      1.287728,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.443957,
      '03300',
      '',
      '',
      0.850743,
      NULL,
      '',
      '',
      5,
      '1434',
      '0233',
      NULL,
      1,
      1.318759,
      NULL,
      2.321576,
      2,
      3.085233,
      2.878693,
      1,
      1);
commit;
end;
/


