set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9105988';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-10-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '300',
      NULL,
      NULL,
      NULL,
      '1304012',
      22,
      4,
      NULL,
      3,
      '021411',
      6.002763,
      ' 7-13-1999',
      36.512782,
      NULL,
      0.476274,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      0.860267,
      NULL,
      0,
      1.973671,
      1.045588,
      1.195625,
      1.679523,
      1.108881,
      0,
      NULL,
      0.520311,
      1.589538,
      0.823503,
      1.198860,
      0,
      0.040806,
      1.441427,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883887,
      1.861188,
      1.064193,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.885720,
      NULL,
      NULL,
      1.353740,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.589183,
      1.459377,
      1.830437,
      0.659821,
      1,
      0.175356,
      NULL,
      1.602165,
      NULL,
      1,
      1.585698,
      0,
      1.927530,
      0.323237,
      NULL,
      1,
      NULL,
      0.419543,
      NULL,
      NULL,
      1.084422,
      NULL,
      0.156933,
      1,
      0.031405,
      1,
      0,
      2.814565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.274118,
      NULL,
      NULL,
      1.790885,
      1.169433,
      NULL,
      0.389981,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      1.114860,
      0.920614,
      1,
      NULL,
      NULL,
      8.775677,
      1.738716,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.955978,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.177530,
      0.931655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080526,
      1,
      0,
      0,
      0,
      1.452128,
      NULL,
      NULL,
      NULL,
      1.548139,
      1,
      0.238216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.500481,
      NULL,
      NULL,
      1,
      1.998489,
      1,
      1.512001,
      1.423910,
      0,
      0.152630,
      NULL,
      0,
      NULL,
      1,
      0.366534,
      1,
      1,
      NULL,
      1.482638,
      0.418143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.845420,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      '43313',
      '',
      '',
      0.335333,
      '',
      NULL,
      '',
      0.996302,
      '',
      NULL,
      '',
      NULL,
      NULL,
      2.703167,
      3.648789,
      NULL,
      0.157815,
      1.254960,
      3.577097,
      1);
commit;
end;
/


