set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '343',
      '34222202',
      0.664190,
      27.932800,
      '3221023',
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      ' 7-14-2003',
      22,
      59.955832,
      NULL,
      NULL,
      0.004303,
      1.720095,
      3.425926,
      1.708614,
      1,
      1.028150,
      1,
      1.020625,
      2.307753,
      1.775977,
      3,
      NULL,
      1,
      1,
      0,
      1.780606,
      2,
      NULL,
      1.824979,
      0.918143,
      1,
      0,
      7,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.390790,
      NULL,
      NULL,
      0.507880,
      1,
      0.127612,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.006140,
      0,
      0.324493,
      4,
      1,
      0,
      0,
      1.450422,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.204474,
      1.732453,
      1,
      1,
      NULL,
      1.303754,
      0.221679,
      1,
      NULL,
      NULL,
      1.945048,
      0.424084,
      0,
      1.631436,
      0.902895,
      NULL,
      1,
      0,
      NULL,
      0,
      1.378034,
      1.230713,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      5.981806,
      4.700075,
      4,
      2.686546,
      2.646773,
      0,
      NULL,
      0,
      1.665758,
      1.399870,
      0.615396,
      NULL,
      NULL,
      0.684084,
      1,
      1.824223,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      0,
      NULL,
      NULL,
      0.869894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.110687,
      2,
      0.508252,
      NULL,
      NULL,
      NULL,
      1,
      0.522778,
      NULL,
      2,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.473234,
      5,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.081424,
      0,
      2.327825,
      1.586648,
      0.702303,
      NULL,
      1.093255,
      3.443723,
      0,
      1.253383,
      2.490746,
      1.901819,
      1.483886,
      1,
      0.153817,
      0.460866,
      1.074415,
      0,
      1.236881,
      0.474403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.244636,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378978,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.452298,
      NULL,
      NULL,
      NULL,
      NULL,
      0.073360,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.328908,
      1.115601,
      NULL,
      0,
      1,
      1.637084,
      0,
      1.492177,
      '',
      '',
      NULL,
      3.274953,
      '34333',
      '',
      NULL,
      3,
      NULL,
      '',
      '',
      2,
      NULL,
      3,
      2,
      0.637665,
      1.779783,
      NULL,
      1,
      1);
commit;
end;
/


