set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-10-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2420',
      NULL,
      8.783456,
      NULL,
      '1321104',
      16,
      5,
      NULL,
      NULL,
      '203221',
      3,
      ' 9- 6-1990',
      32,
      27,
      0,
      NULL,
      NULL,
      2,
      1,
      0.196328,
      0.701012,
      1,
      3,
      NULL,
      1.713803,
      0.603531,
      5.693648,
      0,
      NULL,
      0.104600,
      1.912847,
      NULL,
      7,
      0.184844,
      1,
      NULL,
      3.588338,
      1.927158,
      6.148580,
      1,
      0.713877,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.766299,
      NULL,
      NULL,
      1,
      NULL,
      0.180083,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      0.567503,
      NULL,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.629748,
      NULL,
      NULL,
      4,
      3.749168,
      NULL,
      0.224494,
      0.632119,
      1.503448,
      1.020721,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0.770673,
      1.155816,
      1.878281,
      1.273268,
      1.809592,
      NULL,
      NULL,
      0.341746,
      0,
      0,
      NULL,
      0,
      1,
      1.289618,
      1,
      1,
      0,
      1.213059,
      1,
      0,
      1.200349,
      0,
      1,
      3,
      9.638478,
      8,
      NULL,
      NULL,
      8.532236,
      1,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.951816,
      1,
      0,
      1.721451,
      1.917104,
      2.536840,
      0.919544,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.827320,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.643152,
      3,
      2.898190,
      1,
      4,
      1,
      0.138151,
      NULL,
      5,
      1,
      0.685852,
      NULL,
      NULL,
      NULL,
      1,
      0.220266,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.962141,
      3.790178,
      0,
      NULL,
      0.507458,
      NULL,
      0,
      NULL,
      0,
      0.853689,
      0,
      1,
      0,
      1.470412,
      1.654486,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0.986141,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.993246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.870548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.569305,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584521,
      NULL,
      NULL,
      NULL,
      NULL,
      0.171522,
      1,
      0,
      NULL,
      0.770154,
      1.999400,
      NULL,
      1,
      1.504974,
      '',
      '',
      '',
      2,
      '21201',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      NULL,
      4.130402,
      1.587868,
      2,
      0,
      1.776380,
      3);
commit;
end;
/


