set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-6-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0003',
      '14443412',
      26,
      19.995159,
      '4220211',
      NULL,
      4,
      0.174294,
      0,
      '143411',
      4,
      ' 2-26-1984',
      16,
      50.794961,
      NULL,
      NULL,
      1.175545,
      0,
      1,
      0,
      0,
      NULL,
      0.746881,
      0,
      0.468596,
      1.377729,
      6.911625,
      0.565913,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.134034,
      1.433678,
      1,
      NULL,
      NULL,
      NULL,
      0,
      4.970956,
      2,
      2,
      0.762516,
      NULL,
      NULL,
      1.746064,
      NULL,
      NULL,
      1.371801,
      1.325793,
      7,
      NULL,
      0,
      0.751200,
      NULL,
      0.492605,
      0,
      2,
      NULL,
      3,
      1.562384,
      0.981272,
      NULL,
      0,
      1,
      0.899981,
      1,
      5.986655,
      4.470674,
      1.235389,
      2,
      1,
      0,
      1.166454,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.336950,
      1,
      1,
      2.610667,
      0.733255,
      NULL,
      0.250105,
      1.124647,
      1.388701,
      0.937659,
      1,
      1.347692,
      1,
      NULL,
      NULL,
      1,
      0.389883,
      1,
      NULL,
      1.532544,
      0.048490,
      NULL,
      0.662604,
      0,
      NULL,
      1,
      1,
      NULL,
      3,
      5,
      6.691983,
      1.405081,
      0,
      2,
      NULL,
      7,
      8.736090,
      7,
      NULL,
      6,
      0,
      5,
      1,
      4,
      1.454997,
      0.394895,
      2.402603,
      0,
      0.719062,
      NULL,
      3.361393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.535583,
      1,
      0,
      0,
      0,
      1.648688,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.068070,
      NULL,
      1.234913,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.676785,
      0.930829,
      0,
      0,
      2.973037,
      0,
      7.477407,
      0.746359,
      2.162783,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.257046,
      NULL,
      1.178520,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.319995,
      2,
      1,
      0.138474,
      0,
      0,
      0,
      NULL,
      0.525422,
      3.748550,
      NULL,
      0.630288,
      NULL,
      1,
      0.076458,
      0.431860,
      0,
      1,
      0,
      0.156875,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.342269,
      1.024307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.589810,
      0.633089,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.033754,
      NULL,
      0.309264,
      NULL,
      NULL,
      NULL,
      0.374675,
      NULL,
      0,
      0,
      '',
      '',
      '',
      2,
      '23031',
      '',
      '',
      NULL,
      '3001',
      '',
      '',
      4.880485,
      2.634123,
      NULL,
      4.755916,
      NULL,
      NULL,
      2,
      2.136723,
      NULL);
commit;
end;
/


