set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cashup';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2004-10-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cashup_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1312',
      '00231213',
      NULL,
      44.214265,
      NULL,
      30,
      6,
      0,
      1,
      '412330',
      3.462006,
      ' 8-20-1975',
      4.876987,
      17.752300,
      0,
      NULL,
      1,
      3.229358,
      0.239507,
      0.249794,
      NULL,
      0.148153,
      1,
      0,
      1,
      NULL,
      6.877547,
      1,
      0,
      0,
      1,
      6,
      7,
      1.547021,
      4.229967,
      2.433878,
      1,
      0.073104,
      8,
      NULL,
      3.520886,
      5.307429,
      2.315463,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.250255,
      1,
      6,
      NULL,
      0,
      1,
      1.128760,
      0.100171,
      0,
      3.118370,
      1.975399,
      2.238183,
      1.381228,
      0.466948,
      NULL,
      NULL,
      NULL,
      0,
      0,
      8,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.206296,
      NULL,
      4,
      1.861128,
      6.505996,
      0.467598,
      0.536176,
      1.285479,
      1,
      1,
      1,
      1,
      0.314550,
      0,
      1.167877,
      0,
      NULL,
      1.193164,
      0,
      NULL,
      0.400104,
      0.150272,
      1.767129,
      0.723622,
      1,
      0.662738,
      0.782517,
      1,
      2,
      2.579088,
      1,
      NULL,
      1.255408,
      1.053657,
      3,
      1,
      0.002718,
      3.213529,
      4,
      NULL,
      6.955858,
      NULL,
      4.328234,
      1,
      1.985729,
      NULL,
      NULL,
      NULL,
      0,
      0.057399,
      1.237462,
      0.324430,
      0.806530,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.697297,
      0.281936,
      2,
      2,
      2,
      0,
      NULL,
      1.402213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      8,
      0.969355,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.442596,
      NULL,
      2,
      0.098699,
      0,
      NULL,
      0,
      0,
      2,
      1,
      NULL,
      1,
      2,
      1.479780,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413034,
      3,
      3,
      2,
      1,
      0.660060,
      NULL,
      1,
      NULL,
      2.132184,
      2.477486,
      0,
      NULL,
      0.933781,
      0.487509,
      1.041853,
      1.721853,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.948111,
      0.840305,
      NULL,
      1,
      1,
      1,
      0,
      3.618510,
      NULL,
      NULL,
      NULL,
      0.450447,
      1,
      NULL,
      0.967138,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      0.934829,
      1.508246,
      NULL,
      2,
      0,
      '13312',
      NULL,
      '',
      1,
      '',
      '',
      NULL,
      NULL,
      '0202',
      NULL,
      '',
      5.378913,
      0,
      3.911756,
      7,
      NULL,
      NULL,
      1,
      1.100370,
      0.584734);
commit;
end;
/


